/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

public final class DistanceCalculator {
    private static final double EQUATORIAL_EARTH_RADIUS = 6378.137;
    private static final double DEG_TO_RAD = Math.PI / 180;

    private DistanceCalculator() {
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        double dlong = (lon2 - lon1) * (Math.PI / 180);
        double dlat = (lat2 - lat1) * (Math.PI / 180);
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1 * (Math.PI / 180)) * Math.cos(lat2 * (Math.PI / 180)) * Math.pow(Math.sin(dlong / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = 6378.137 * c;
        return d * 1000.0;
    }

    public static double distanceToLine(double pointLat, double pointLon, double lat1, double lon1, double lat2, double lon2) {
        double d0 = DistanceCalculator.distance(pointLat, pointLon, lat1, lon1);
        double d1 = DistanceCalculator.distance(lat1, lon1, lat2, lon2);
        double d2 = DistanceCalculator.distance(lat2, lon2, pointLat, pointLon);
        if (Math.pow(d0, 2.0) > Math.pow(d1, 2.0) + Math.pow(d2, 2.0)) {
            return d2;
        }
        if (Math.pow(d2, 2.0) > Math.pow(d1, 2.0) + Math.pow(d0, 2.0)) {
            return d0;
        }
        double halfP = (d0 + d1 + d2) * 0.5;
        double area = Math.sqrt(halfP * (halfP - d0) * (halfP - d1) * (halfP - d2));
        return 2.0 * area / d1;
    }
}

