/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.snapshot.LeafNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Utilities;

public class DoubleNode
extends LeafNode<DoubleNode> {
    private final Double value;

    public DoubleNode(Double value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        String toHash = this.getPriorityHash(version);
        toHash = toHash + "number:";
        toHash = toHash + Utilities.doubleToHashString(this.value);
        return toHash;
    }

    @Override
    public DoubleNode updatePriority(Node priority) {
        assert (PriorityUtilities.isValidPriority(priority));
        return new DoubleNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.Number;
    }

    @Override
    protected int compareLeafValues(DoubleNode other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DoubleNode)) {
            return false;
        }
        DoubleNode otherDoubleNode = (DoubleNode)other;
        return this.value.equals(otherDoubleNode.value) && this.priority.equals(otherDoubleNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

