/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.internals.Change;

public final class FullChangeSerde<T> {
    private final Serde<T> inner;

    public static <T> FullChangeSerde<T> wrap(Serde<T> serde) {
        if (serde == null) {
            return null;
        }
        return new FullChangeSerde<T>(serde);
    }

    private FullChangeSerde(Serde<T> inner) {
        this.inner = Objects.requireNonNull(inner);
    }

    public Serde<T> innerSerde() {
        return this.inner;
    }

    public Change<byte[]> serializeParts(String topic, Change<T> data) {
        if (data == null) {
            return null;
        }
        Serializer innerSerializer = this.innerSerde().serializer();
        byte[] oldBytes = data.oldValue == null ? null : innerSerializer.serialize(topic, data.oldValue);
        byte[] newBytes = data.newValue == null ? null : innerSerializer.serialize(topic, data.newValue);
        return new Change<byte[]>(newBytes, oldBytes);
    }

    public Change<T> deserializeParts(String topic, Change<byte[]> serialChange) {
        if (serialChange == null) {
            return null;
        }
        Deserializer innerDeserializer = this.innerSerde().deserializer();
        Object oldValue = serialChange.oldValue == null ? null : innerDeserializer.deserialize(topic, (byte[])serialChange.oldValue);
        Object newValue = serialChange.newValue == null ? null : innerDeserializer.deserialize(topic, (byte[])serialChange.newValue);
        return new Change<Object>(newValue, oldValue);
    }

    public static Change<byte[]> decomposeLegacyFormattedArrayIntoChangeArrays(byte[] data) {
        if (data == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte[] oldBytes = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        byte[] newBytes = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        return new Change<byte[]>(newBytes, oldBytes);
    }
}

