/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumFieldLimitingUpdateRequestProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String MAXIMUM_FIELDS_PARAM = "maxFields";
    private static final String WARN_ONLY_PARAM = "warnOnly";
    int maximumFields;
    boolean warnOnly;

    @Override
    public void init(NamedList<?> args) {
        boolean bl = this.warnOnly = args.indexOf(WARN_ONLY_PARAM, 0) > 0 ? args.getBooleanArg(WARN_ONLY_PARAM) : false;
        if (args.indexOf(MAXIMUM_FIELDS_PARAM, 0) < 0) {
            throw new IllegalArgumentException("The maxFields parameter is required for " + this.getClass().getName() + ", but no value was provided.");
        }
        Object rawMaxFields = args.get(MAXIMUM_FIELDS_PARAM);
        if (!(rawMaxFields instanceof Integer)) {
            throw new IllegalArgumentException("maxFields must be configured as a non-null <int>");
        }
        this.maximumFields = (Integer)rawMaxFields;
        if (this.maximumFields <= 0) {
            throw new IllegalArgumentException("maxFields must be a positive integer");
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        final int currentNumFields = req.getSearcher().getFieldInfos().size();
        if (currentNumFields <= this.maximumFields) {
            return next;
        }
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                String id = cmd.getPrintableId();
                Object messageSuffix = NumFieldLimitingUpdateRequestProcessorFactory.this.warnOnly ? "Blocking update of document " + id : "";
                String message = String.format(Locale.ROOT, "Current core has %d fields, exceeding the max-fields limit of %d.  %s", currentNumFields, NumFieldLimitingUpdateRequestProcessorFactory.this.maximumFields, messageSuffix);
                if (!NumFieldLimitingUpdateRequestProcessorFactory.this.warnOnly) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                log.warn(message);
            }
        };
    }
}

