/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QueryResult;
import org.apache.solr.search.SolrIndexSearcher;

public class QueryCommand {
    private Query query;
    private String queryID;
    private boolean isQueryCancellable;
    private List<Query> filterList;
    private DocSet filter;
    private Sort sort;
    private int offset;
    private int len;
    private int supersetMaxDoc;
    private int flags;
    private boolean multiThreaded = false;
    private long timeAllowed = -1L;
    private int minExactCount = Integer.MAX_VALUE;
    private CursorMark cursorMark;
    private boolean distribStatsDisabled;

    public CursorMark getCursorMark() {
        return this.cursorMark;
    }

    public QueryCommand setCursorMark(CursorMark cursorMark) {
        this.cursorMark = cursorMark;
        if (null != cursorMark) {
            this.flags |= 0x90000000;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryCommand setQuery(Query query) {
        this.query = query;
        return this;
    }

    public List<Query> getFilterList() {
        return this.filterList;
    }

    public QueryCommand setFilterList(List<Query> filterList) {
        if (this.filter != null) {
            throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
        }
        this.filterList = filterList;
        return this;
    }

    public QueryCommand setFilterList(Query f) {
        if (this.filter != null) {
            throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
        }
        this.filterList = null;
        if (f != null) {
            this.filterList = new ArrayList<Query>(2);
            this.filterList.add(f);
        }
        return this;
    }

    public DocSet getFilter() {
        return this.filter;
    }

    public QueryCommand setFilter(DocSet filter) {
        if (this.filterList != null) {
            throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
        }
        this.filter = filter;
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public QueryCommand setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public QueryCommand setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLen() {
        return this.len;
    }

    public QueryCommand setLen(int len) {
        this.len = len;
        return this;
    }

    public int getSupersetMaxDoc() {
        return this.supersetMaxDoc;
    }

    public QueryCommand setSupersetMaxDoc(int supersetMaxDoc) {
        this.supersetMaxDoc = supersetMaxDoc;
        return this;
    }

    public int getFlags() {
        return this.flags;
    }

    public QueryCommand replaceFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public QueryCommand setFlags(int flags) {
        this.flags |= flags;
        return this;
    }

    public QueryCommand clearFlags(int flags) {
        this.flags &= ~flags;
        return this;
    }

    public boolean getMultiThreaded() {
        return this.multiThreaded;
    }

    public QueryCommand setMultiThreaded(boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
        return this;
    }

    public long getTimeAllowed() {
        return this.timeAllowed;
    }

    public QueryCommand setTimeAllowed(long timeAllowed) {
        this.timeAllowed = timeAllowed;
        return this;
    }

    public int getMinExactCount() {
        return this.minExactCount;
    }

    public QueryCommand setMinExactCount(int count) {
        this.minExactCount = count;
        return this;
    }

    public boolean isNeedDocSet() {
        return (this.flags & 0x40000000) != 0;
    }

    public QueryCommand setNeedDocSet(boolean needDocSet) {
        if (needDocSet) {
            return this.setFlags(0x40000000);
        }
        return this.clearFlags(0x40000000);
    }

    public boolean getTerminateEarly() {
        return (this.flags & 4) != 0;
    }

    public QueryCommand setTerminateEarly(boolean segmentTerminateEarly) {
        if (segmentTerminateEarly) {
            return this.setFlags(4);
        }
        return this.clearFlags(4);
    }

    public boolean getSegmentTerminateEarly() {
        return (this.flags & 8) != 0;
    }

    public QueryCommand setSegmentTerminateEarly(boolean segmentSegmentTerminateEarly) {
        if (segmentSegmentTerminateEarly) {
            return this.setFlags(8);
        }
        return this.clearFlags(8);
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public void setQueryCancellable(boolean isQueryCancellable) {
        this.isQueryCancellable = isQueryCancellable;
    }

    public boolean isQueryCancellable() {
        return this.isQueryCancellable;
    }

    public void setDistribStatsDisabled(boolean distribStatsDisabled) {
        this.distribStatsDisabled = distribStatsDisabled;
    }

    public boolean isDistribStatsDisabled() {
        return this.distribStatsDisabled;
    }

    public QueryResult search(SolrIndexSearcher searcher) throws IOException {
        return searcher.search(this);
    }
}

