/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;

public class AssignmentMemberSpec {
    private final Optional<String> instanceId;
    private final Optional<String> rackId;
    private final Collection<Uuid> subscribedTopicIds;
    private final Map<Uuid, Set<Integer>> assignedPartitions;

    public Optional<String> instanceId() {
        return this.instanceId;
    }

    public Optional<String> rackId() {
        return this.rackId;
    }

    public Collection<Uuid> subscribedTopicIds() {
        return this.subscribedTopicIds;
    }

    public Map<Uuid, Set<Integer>> assignedPartitions() {
        return this.assignedPartitions;
    }

    public AssignmentMemberSpec(Optional<String> instanceId, Optional<String> rackId, Collection<Uuid> subscribedTopicIds, Map<Uuid, Set<Integer>> assignedPartitions) {
        Objects.requireNonNull(instanceId);
        Objects.requireNonNull(rackId);
        Objects.requireNonNull(subscribedTopicIds);
        Objects.requireNonNull(assignedPartitions);
        this.instanceId = instanceId;
        this.rackId = rackId;
        this.subscribedTopicIds = subscribedTopicIds;
        this.assignedPartitions = assignedPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentMemberSpec that = (AssignmentMemberSpec)o;
        if (!this.instanceId.equals(that.instanceId)) {
            return false;
        }
        if (!this.rackId.equals(that.rackId)) {
            return false;
        }
        if (!this.subscribedTopicIds.equals(that.subscribedTopicIds)) {
            return false;
        }
        return this.assignedPartitions.equals(that.assignedPartitions);
    }

    public int hashCode() {
        int result = this.instanceId.hashCode();
        result = 31 * result + this.rackId.hashCode();
        result = 31 * result + this.subscribedTopicIds.hashCode();
        result = 31 * result + this.assignedPartitions.hashCode();
        return result;
    }

    public String toString() {
        return "AssignmentMemberSpec(instanceId=" + this.instanceId + ", rackId=" + this.rackId + ", subscribedTopicIds=" + this.subscribedTopicIds + ", assignedPartitions=" + this.assignedPartitions + ')';
    }
}

