/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpExceptionUtils {
    public static final String ERROR_JSON = "RemoteException";
    public static final String ERROR_EXCEPTION_JSON = "exception";
    public static final String ERROR_CLASSNAME_JSON = "javaClassName";
    public static final String ERROR_MESSAGE_JSON = "message";
    private static final String APPLICATION_JSON_MIME = "application/json";
    private static final String ENTER = System.getProperty("line.separator");

    public static void createServletExceptionResponse(HttpServletResponse response, int status, Throwable ex) throws IOException {
        response.setStatus(status);
        response.setContentType(APPLICATION_JSON_MIME);
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put(ERROR_MESSAGE_JSON, HttpExceptionUtils.getOneLineMessage(ex));
        json.put(ERROR_EXCEPTION_JSON, ex.getClass().getSimpleName());
        json.put(ERROR_CLASSNAME_JSON, ex.getClass().getName());
        Map jsonResponse = Collections.singletonMap(ERROR_JSON, json);
        PrintWriter writer = response.getWriter();
        JsonSerialization.writer().writeValue((Writer)writer, jsonResponse);
        ((Writer)writer).flush();
    }

    public static Response createJerseyExceptionResponse(Response.Status status, Throwable ex) {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put(ERROR_MESSAGE_JSON, HttpExceptionUtils.getOneLineMessage(ex));
        json.put(ERROR_EXCEPTION_JSON, ex.getClass().getSimpleName());
        json.put(ERROR_CLASSNAME_JSON, ex.getClass().getName());
        Map response = Collections.singletonMap(ERROR_JSON, json);
        return Response.status((Response.Status)status).type(APPLICATION_JSON_MIME).entity(response).build();
    }

    private static String getOneLineMessage(Throwable exception) {
        int i;
        String message = exception.getMessage();
        if (message != null && (i = message.indexOf(ENTER)) > -1) {
            message = message.substring(0, i);
        }
        return message;
    }

    private static void throwEx(Throwable ex) {
        HttpExceptionUtils.throwException(ex);
    }

    private static <E extends Throwable> void throwException(Throwable ex) throws E {
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateResponse(HttpURLConnection conn, int expectedStatus) throws IOException {
        if (conn.getResponseCode() != expectedStatus) {
            Exception toThrow;
            InputStream es = null;
            try {
                es = conn.getErrorStream();
                Map json = (Map)JsonSerialization.mapReader().readValue(es);
                json = (Map)json.get(ERROR_JSON);
                String exClass = (String)json.get(ERROR_CLASSNAME_JSON);
                String exMsg = (String)json.get(ERROR_MESSAGE_JSON);
                if (exClass != null) {
                    try {
                        ClassLoader cl = HttpExceptionUtils.class.getClassLoader();
                        Class<?> klass = cl.loadClass(exClass);
                        Constructor<?> constr = klass.getConstructor(String.class);
                        toThrow = (Exception)constr.newInstance(exMsg);
                    }
                    catch (Exception ex) {
                        toThrow = new IOException(String.format("HTTP status [%d], exception [%s], message [%s], URL [%s]", conn.getResponseCode(), exClass, exMsg, conn.getURL()));
                    }
                } else {
                    String msg = exMsg != null ? exMsg : conn.getResponseMessage();
                    toThrow = new IOException(String.format("HTTP status [%d], message [%s], URL [%s]", conn.getResponseCode(), msg, conn.getURL()));
                }
            }
            catch (Exception ex) {
                toThrow = new IOException(String.format("HTTP status [%d], message [%s], URL [%s], exception [%s]", conn.getResponseCode(), conn.getResponseMessage(), conn.getURL(), ex.toString()), ex);
            }
            finally {
                if (es != null) {
                    try {
                        es.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            HttpExceptionUtils.throwEx(toThrow);
        }
    }
}

