/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RncBlock
implements Block {
    private final ASTNode myNode;

    RncBlock(ASTNode element) {
        this.myNode = element;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            RncBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        ArrayList<Block> list2 = new ArrayList<Block>();
        for (ASTNode node = this.myNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (RncTokenTypes.WHITESPACE.contains(node.getElementType()) || node.getTextLength() <= 0) continue;
            list2.add(new RncBlock(node));
        }
        ArrayList<Block> arrayList = list2;
        if (arrayList == null) {
            RncBlock.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        if (this.myNode.getTreeParent() == null) {
            return null;
        }
        if (this.isTopLevel()) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (this.myNode.getTreeParent().getPsi() instanceof RncGrammar && !RncTokenTypes.BRACES.contains(this.myNode.getElementType())) {
            return Indent.getNormalIndent();
        }
        return null;
    }

    private boolean isTopLevel() {
        PsiElement parent = this.myNode.getTreeParent().getPsi();
        return parent instanceof RncDocument || parent instanceof RncFile || parent instanceof RncGrammar && parent.getParent() instanceof RncDocument;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            RncBlock.$$$reportNull$$$0(2);
        }
        if (child1 == null) {
            return null;
        }
        ASTNode lnode = ((RncBlock)child1).myNode;
        PsiElement lpsi = lnode.getPsi();
        PsiElement rpsi = ((RncBlock)child2).myNode.getPsi();
        if (lpsi instanceof RncDecl && rpsi instanceof RncDecl) {
            return RncBlock.makeNewline();
        }
        if ((lpsi instanceof RncDecl || lpsi instanceof RncDefine || lnode.getElementType() == RncElementTypes.START) && (rpsi instanceof RncDefine || rpsi instanceof RncGrammar)) {
            return RncBlock.makeNewline();
        }
        return null;
    }

    private static Spacing makeNewline() {
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)true, (int)100);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/formatting/RncBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/formatting/RncBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

