/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.sax;

import jp.gr.xml.relax.dom.DOMVisitorException;
import jp.gr.xml.relax.dom.UDOMVisitor;
import jp.gr.xml.relax.sax.DOMSAXProducerVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class DOMSAXProducer {
    private boolean needDocumentEmulation_ = true;
    private Node root_;
    private String systemID_;
    private String publicID_;
    private DTDHandler dtd_;
    private ContentHandler content_;
    private DeclHandler decl_;
    private LexicalHandler lexical_;
    private ErrorHandler error_;

    public DOMSAXProducer(Node node) {
        this.root_ = node;
    }

    public void setDocumentEmulation(boolean emulate) {
        this.needDocumentEmulation_ = emulate;
    }

    public void setDTDHandler(DTDHandler dtd) {
        this.dtd_ = dtd;
    }

    public void setContentHandler(ContentHandler content) {
        this.content_ = content;
    }

    public void setLexicalHandler(LexicalHandler lexical) {
        this.lexical_ = lexical;
    }

    public void setDeclHandler(DeclHandler decl) {
        this.decl_ = decl;
    }

    public void setErrorHandler(ErrorHandler error) {
        this.error_ = error;
    }

    public void makeEvent() throws SAXException {
        try {
            DOMSAXProducerVisitor visitor = new DOMSAXProducerVisitor();
            visitor.setSystemID(this.systemID_);
            visitor.setPublicID(this.publicID_);
            visitor.setDTDHandler(this.dtd_);
            visitor.setContentHandler(this.content_);
            visitor.setLexicalHandler(this.lexical_);
            visitor.setDeclHandler(this.decl_);
            visitor.setErrorHandler(this.error_);
            if (!(this.root_ instanceof Document) && this.needDocumentEmulation_) {
                visitor.emulateStartDocument();
                UDOMVisitor.traverse(this.root_, visitor);
                visitor.emulateEndDocument();
            } else {
                UDOMVisitor.traverse(this.root_, visitor);
            }
        }
        catch (DOMVisitorException e) {
            Exception cause = e.getCauseException();
            if (cause == null) {
                throw new SAXException(e.getMessage());
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new SAXException(e.getMessage());
        }
    }

    public void makeEvent(ContentHandler handler2) throws SAXException {
        this.setContentHandler(handler2);
        this.makeEvent();
    }
}

