/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rng;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.parse.Context;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Analyzer
extends AbstractVisitor {
    private String datatypeLibrary = null;
    private final Map prefixMap = new HashMap();
    private boolean haveInherit = false;
    private Context lastContext = null;

    Analyzer() {
    }

    private Object visitAnnotated(Annotated annotated) {
        if (annotated.getAttributeAnnotations().size() > 0 || annotated.getChildElementAnnotations().size() > 0 || annotated.getFollowingElementAnnotations().size() > 0) {
            this.noteContext(annotated.getContext());
        }
        this.visitAnnotationAttributes(annotated.getAttributeAnnotations());
        this.visitAnnotationChildren(annotated.getChildElementAnnotations());
        this.visitAnnotationChildren(annotated.getFollowingElementAnnotations());
        return null;
    }

    private void visitAnnotationAttributes(List list2) {
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            AttributeAnnotation attributeAnnotation = (AttributeAnnotation)list2.get(n);
            if (attributeAnnotation.getNamespaceUri().length() != 0) {
                this.noteNs(attributeAnnotation.getPrefix(), attributeAnnotation.getNamespaceUri());
            }
            ++n;
        }
    }

    private void visitAnnotationChildren(List list2) {
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            AnnotationChild annotationChild = (AnnotationChild)list2.get(n);
            if (annotationChild instanceof ElementAnnotation) {
                ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
                if (elementAnnotation.getPrefix() != null) {
                    this.noteNs(elementAnnotation.getPrefix(), elementAnnotation.getNamespaceUri());
                }
                this.visitAnnotationAttributes(elementAnnotation.getAttributes());
                this.visitAnnotationChildren(elementAnnotation.getChildren());
            }
            ++n;
        }
    }

    public Object visitPattern(Pattern pattern) {
        return this.visitAnnotated(pattern);
    }

    public Object visitDefine(DefineComponent defineComponent) {
        this.visitAnnotated(defineComponent);
        return defineComponent.getBody().accept(this);
    }

    public Object visitDiv(DivComponent divComponent) {
        this.visitAnnotated(divComponent);
        return this.visitContainer(divComponent);
    }

    public Object visitInclude(IncludeComponent includeComponent) {
        this.visitAnnotated(includeComponent);
        return this.visitContainer(includeComponent);
    }

    public Object visitGrammar(GrammarPattern grammarPattern) {
        this.visitAnnotated(grammarPattern);
        return this.visitContainer(grammarPattern);
    }

    private Object visitContainer(Container container) {
        List list2 = container.getComponents();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            ((Component)list2.get(n)).accept(this);
            ++n;
        }
        return null;
    }

    public Object visitUnary(UnaryPattern unaryPattern) {
        this.visitAnnotated(unaryPattern);
        return unaryPattern.getChild().accept(this);
    }

    public Object visitComposite(CompositePattern compositePattern) {
        this.visitAnnotated(compositePattern);
        List list2 = compositePattern.getChildren();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            ((Pattern)list2.get(n)).accept(this);
            ++n;
        }
        return null;
    }

    public Object visitNameClassed(NameClassedPattern nameClassedPattern) {
        nameClassedPattern.getNameClass().accept(this);
        return this.visitUnary(nameClassedPattern);
    }

    public Object visitAttribute(AttributePattern attributePattern) {
        NameClass nameClass = attributePattern.getNameClass();
        if (nameClass instanceof NameNameClass && ((NameNameClass)nameClass).getNamespaceUri().equals("")) {
            return this.visitUnary(attributePattern);
        }
        return this.visitNameClassed(attributePattern);
    }

    public Object visitChoice(ChoiceNameClass choiceNameClass) {
        this.visitAnnotated(choiceNameClass);
        List list2 = choiceNameClass.getChildren();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            ((NameClass)list2.get(n)).accept(this);
            ++n;
        }
        return null;
    }

    public Object visitValue(ValuePattern valuePattern) {
        this.visitAnnotated(valuePattern);
        if (!valuePattern.getType().equals("token") || !valuePattern.getDatatypeLibrary().equals("")) {
            this.noteDatatypeLibrary(valuePattern.getDatatypeLibrary());
        }
        Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.noteNs((String)entry.getKey(), (String)entry.getValue());
        }
        return null;
    }

    public Object visitData(DataPattern dataPattern) {
        this.visitAnnotated(dataPattern);
        this.noteDatatypeLibrary(dataPattern.getDatatypeLibrary());
        Pattern pattern = dataPattern.getExcept();
        if (pattern != null) {
            pattern.accept(this);
        }
        Iterator iterator = dataPattern.getParams().iterator();
        while (iterator.hasNext()) {
            this.visitAnnotated((Param)iterator.next());
        }
        return null;
    }

    public Object visitName(NameNameClass nameNameClass) {
        this.visitAnnotated(nameNameClass);
        this.noteNs(nameNameClass.getPrefix(), nameNameClass.getNamespaceUri());
        return null;
    }

    public Object visitAnyName(AnyNameNameClass anyNameNameClass) {
        this.visitAnnotated(anyNameNameClass);
        NameClass nameClass = anyNameNameClass.getExcept();
        if (nameClass != null) {
            nameClass.accept(this);
        }
        return null;
    }

    public Object visitNsName(NsNameNameClass nsNameNameClass) {
        this.visitAnnotated(nsNameNameClass);
        this.noteInheritNs(nsNameNameClass.getNs());
        NameClass nameClass = nsNameNameClass.getExcept();
        if (nameClass != null) {
            nameClass.accept(this);
        }
        return null;
    }

    private void noteDatatypeLibrary(String string) {
        if (this.datatypeLibrary == null || this.datatypeLibrary.length() == 0) {
            this.datatypeLibrary = string;
        }
    }

    private void noteInheritNs(String string) {
        if (string == NameClass.INHERIT_NS) {
            this.haveInherit = true;
        }
    }

    private void noteNs(String string, String string2) {
        if (string2 == NameClass.INHERIT_NS) {
            this.haveInherit = true;
            return;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0 && string.length() != 0 || this.prefixMap.containsKey(string)) {
            return;
        }
        this.prefixMap.put(string, string2);
    }

    private void noteContext(Context context) {
        if (context == null || context == this.lastContext) {
            return;
        }
        this.lastContext = context;
        Enumeration enumeration = context.prefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.noteNs(string, context.resolveNamespacePrefix(string));
        }
    }

    Map getPrefixMap() {
        if (this.haveInherit) {
            this.prefixMap.remove("");
        }
        this.prefixMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        return this.prefixMap;
    }

    String getDatatypeLibrary() {
        return this.datatypeLibrary;
    }
}

