/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class VcsAbstractHistorySession
implements VcsHistorySession {
    private final List<VcsFileRevision> myRevisions;
    private final Object myLock = new Object();
    private VcsRevisionNumber myCachedRevisionNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VcsRevisionNumber getCachedRevision() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCachedRevisionNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedRevision(VcsRevisionNumber number) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCachedRevisionNumber = number;
        }
    }

    public VcsAbstractHistorySession(List<? extends VcsFileRevision> revisions) {
        this.myRevisions = new ArrayList<VcsFileRevision>(revisions);
        this.myCachedRevisionNumber = this.calcCurrentRevisionNumber();
    }

    protected VcsAbstractHistorySession(List<? extends VcsFileRevision> revisions, VcsRevisionNumber currentRevisionNumber) {
        this.myRevisions = new ArrayList<VcsFileRevision>(revisions);
        this.myCachedRevisionNumber = currentRevisionNumber;
    }

    @Override
    public List<VcsFileRevision> getRevisionList() {
        return this.myRevisions;
    }

    public void appendRevision(VcsFileRevision revision) {
        this.myRevisions.add(revision);
    }

    @Nullable
    protected abstract VcsRevisionNumber calcCurrentRevisionNumber();

    @Nullable
    @ApiStatus.Internal
    public final VcsRevisionNumber calcCurrentRevisionNumberForCache() {
        return this.calcCurrentRevisionNumber();
    }

    @Override
    public final VcsRevisionNumber getCurrentRevisionNumber() {
        return this.getCachedRevision();
    }

    @Override
    public boolean isCurrentRevision(VcsRevisionNumber rev) {
        VcsRevisionNumber revNumber = this.getCurrentRevisionNumber();
        return revNumber != null && revNumber.compareTo(rev) == 0;
    }

    @Override
    public synchronized boolean shouldBeRefreshed() {
        VcsRevisionNumber oldValue = this.getCachedRevision();
        VcsRevisionNumber newNumber = this.calcCurrentRevisionNumber();
        this.setCachedRevision(newNumber);
        return !Comparing.equal((Object)oldValue, (Object)newNumber);
    }

    @Override
    public boolean isContentAvailable(VcsFileRevision revision) {
        return true;
    }

    public abstract VcsHistorySession copy();

    public VcsHistorySession copyWithCachedRevision() {
        VcsAbstractHistorySession copy = (VcsAbstractHistorySession)this.copy();
        copy.setCachedRevision(this.myCachedRevisionNumber);
        return copy;
    }

    public Map<VcsRevisionNumber, VcsFileRevision> getHistoryAsMap() {
        HashMap<VcsRevisionNumber, VcsFileRevision> map = new HashMap<VcsRevisionNumber, VcsFileRevision>();
        for (VcsFileRevision revision : this.myRevisions) {
            map.put(revision.getRevisionNumber(), revision);
        }
        return map;
    }

    @Override
    public boolean hasLocalSource() {
        return true;
    }
}

