/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.html.embedding.HtmlCustomEmbeddedContentTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.html.HTMLParser;
import com.intellij.lang.xml.XMLParserDefinition;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.xml.stub.XmlStubBasedElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.UnsupportedNodeElementTypeException;
import com.intellij.psi.xml.HtmlFileElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HTMLParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE_ELEMENT_TYPE = new HtmlFileElementType();

    @NotNull
    public Lexer createLexer(Project project2) {
        return new HtmlLexer();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = XmlElementType.HTML_FILE;
        if (iFileElementType == null) {
            HTMLParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = XmlTokenType.WHITESPACES;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = XmlTokenType.COMMENTS;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project2) {
        return new HTMLParser();
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() instanceof XmlStubBasedElementType) {
            Object PsiT = ((XmlStubBasedElementType)node.getElementType()).createPsi(node);
            if (PsiT == null) {
                HTMLParserDefinition.$$$reportNull$$$0(4);
            }
            return PsiT;
        }
        if (node.getElementType() instanceof HtmlCustomEmbeddedContentTokenType) {
            PsiElement psiElement = ((HtmlCustomEmbeddedContentTokenType)node.getElementType()).createPsi(node);
            if (psiElement == null) {
                HTMLParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        if (node.getElementType() == XmlElementType.HTML_EMBEDDED_CONTENT) {
            return new HtmlEmbeddedContentImpl(node);
        }
        throw new UnsupportedNodeElementTypeException(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            HTMLParserDefinition.$$$reportNull$$$0(6);
        }
        return new HtmlFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = XMLParserDefinition.canStickTokensTogether(left, right);
        if (spaceRequirements == null) {
            HTMLParserDefinition.$$$reportNull$$$0(7);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/html/HTMLParserDefinition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/html/HTMLParserDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6 -> new IllegalArgumentException(string);
        };
    }
}

