/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public abstract class AbstractFillerWordsRule
extends TextLevelRule {
    public static final String RULE_ID = "FILLER_WORDS";
    private static final int DEFAULT_MIN_PERCENT = 8;
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u201d\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private static final boolean DEFAULT_ACTIVATION = false;
    private int minPercent = 8;
    private final Language lang;

    protected abstract boolean isFillerWord(String var1);

    public AbstractFillerWordsRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean defaultActive) {
        super(messages);
        int confPercent;
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.lang = lang;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        if (userConfig != null && (confPercent = userConfig.getConfigValueByID(this.getId())) >= 0) {
            this.minPercent = confPercent;
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public AbstractFillerWordsRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        this(messages, lang, userConfig, false);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("filler_words_rule_desc");
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int getDefaultValue() {
        return this.minPercent;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 0;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 100;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("filler_words_rule_opt_text");
    }

    public String getMessage() {
        return this.messages.getString("filler_words_rule_msg");
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int num) {
        return false;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences2) throws IOException {
        double percent;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String msg = this.getMessage();
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> relevantSentences = new ArrayList<AnalyzedSentence>();
        int pos = 0;
        int wordCount = 0;
        boolean isDirectSpeech = false;
        for (int nSentence = 0; nSentence < sentences2.size(); ++nSentence) {
            AnalyzedSentence sentence = sentences2.get(nSentence);
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int n = 1; n < tokens.length; ++n) {
                AnalyzedTokenReadings token = tokens[n];
                String sToken = token.getToken();
                if (!isDirectSpeech && OPENING_QUOTES.matcher(sToken).matches() && n < tokens.length - 1 && !tokens[n + 1].isWhitespaceBefore()) {
                    isDirectSpeech = true;
                    continue;
                }
                if (isDirectSpeech && ENDING_QUOTES.matcher(sToken).matches() && n > 1 && !tokens[n].isWhitespaceBefore()) {
                    isDirectSpeech = false;
                    continue;
                }
                if (isDirectSpeech && this.minPercent != 0 || token.isWhitespace() || token.isNonWord()) continue;
                ++wordCount;
                if (!this.isFillerWord(sToken) || this.isException(tokens, n)) continue;
                startPos.add(token.getStartPos() + pos);
                endPos.add(token.getEndPos() + pos);
                relevantSentences.add(sentence);
            }
            if (Tools.isParagraphEnd(sentences2, nSentence, this.lang)) {
                percent = wordCount > 0 ? (double)startPos.size() * 100.0 / (double)wordCount : 0.0;
                if (percent > (double)this.minPercent) {
                    for (int i = 0; i < startPos.size(); ++i) {
                        RuleMatch ruleMatch = new RuleMatch(this, (AnalyzedSentence)relevantSentences.get(i), (Integer)startPos.get(i), (Integer)endPos.get(i), msg);
                        ruleMatches.add(ruleMatch);
                    }
                }
                wordCount = 0;
                startPos = new ArrayList();
                endPos = new ArrayList();
                relevantSentences = new ArrayList();
            }
            pos += sentence.getCorrectedTextLength();
        }
        percent = wordCount > 0 ? (double)startPos.size() * 100.0 / (double)wordCount : 0.0;
        if (percent > (double)this.minPercent) {
            for (int i = 0; i < startPos.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch(this, (AnalyzedSentence)relevantSentences.get(i), (Integer)startPos.get(i), (Integer)endPos.get(i), msg);
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

