/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YamlSearchEverywhereResultsCollectorKt;

public class YAMLKeysSearchEverywhereContributor
implements SearchEverywhereContributor<YAMLKeyNavigationItem> {
    private final Project myProject;

    public YAMLKeysSearchEverywhereContributor(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = YAMLBundle.message((String)"YAMLKeysSearchEverywhereContributor.group.name", (Object[])new Object[0]);
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getSortWeight() {
        return 1000;
    }

    public boolean showInFindResults() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super YAMLKeyNavigationItem> consumer) {
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (this.myProject == null || pattern.isEmpty()) {
            return;
        }
        Runnable task = () -> this.findKeys(consumer, pattern);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.runReadAction(task);
        } else {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)task, (ProgressIndicator)progressIndicator);
        }
    }

    public boolean processSelectedItem(@NotNull YAMLKeyNavigationItem selected, int modifiers, @NotNull String searchText) {
        if (selected == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        if (searchText == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        selected.navigate(true);
        return true;
    }

    @NotNull
    public ListCellRenderer<? super Object> getElementsRenderer() {
        return new NavigationItemListCellRenderer();
    }

    private void findKeys(@NotNull Processor<? super YAMLKeyNavigationItem> consumer, @NotNull String pattern) {
        if (consumer == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (ActionUtil.isDumbMode((Project)this.myProject)) {
            return;
        }
        assert (this.myProject != null);
        GlobalSearchScope filter = SearchEverywhereManager.getInstance((Project)this.myProject).isEverywhere() ? ProjectScope.getAllScope((Project)this.myProject) : ProjectScope.getProjectScope((Project)this.myProject);
        Plow.ofSequence(YamlSearchEverywhereResultsCollectorKt.searchForKey(pattern, filter, this.myProject)).cancellable().mapNotNull(keyData -> new YAMLKeyNavigationItem(this.myProject, keyData.getKey(), keyData.getFile(), keyData.getOffset(), this.computePrettyLocation(keyData.getFile()))).processWith(consumer);
    }

    @NotNull
    @NlsSafe
    private String computePrettyLocation(VirtualFile file) {
        VirtualFile root = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(file);
        if (root == null) {
            String string = file.getName();
            if (string == null) {
                YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root);
        String string = relativePath == null ? file.getName() : relativePath;
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computePrettyLocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<YAMLKeyNavigationItem> {
        @NotNull
        public SearchEverywhereContributor<YAMLKeyNavigationItem> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new YAMLKeysSearchEverywhereContributor(initEvent.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initEvent", "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

