/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.cache;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "", "documentPrefixHash", "", "documentPostfixHash", "linePrefix", "", "lineSuffix", "filePath", "<init>", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDocumentPrefixHash", "()I", "getDocumentPostfixHash", "getLinePrefix", "()Ljava/lang/String;", "getLineSuffix", "getFilePath", "matches", "", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "hashCode", "toString", "Companion", "intellij.ml.inline.completion"})
public final class LightweightCacheKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int documentPrefixHash;
    private final int documentPostfixHash;
    @NotNull
    private final String linePrefix;
    @NotNull
    private final String lineSuffix;
    @NotNull
    private final String filePath;

    public LightweightCacheKey(int documentPrefixHash, int documentPostfixHash, @NotNull String linePrefix, @NotNull String lineSuffix, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        Intrinsics.checkNotNullParameter((Object)lineSuffix, (String)"lineSuffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.documentPrefixHash = documentPrefixHash;
        this.documentPostfixHash = documentPostfixHash;
        this.linePrefix = linePrefix;
        this.lineSuffix = lineSuffix;
        this.filePath = filePath;
    }

    public final int getDocumentPrefixHash() {
        return this.documentPrefixHash;
    }

    public final int getDocumentPostfixHash() {
        return this.documentPostfixHash;
    }

    @NotNull
    public final String getLinePrefix() {
        return this.linePrefix;
    }

    @NotNull
    public final String getLineSuffix() {
        return this.lineSuffix;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final boolean matches(@NotNull LightweightCacheKey other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.documentPrefixHash == other.documentPrefixHash && this.documentPostfixHash == other.documentPostfixHash && Intrinsics.areEqual((Object)this.filePath, (Object)other.filePath) && StringsKt.endsWith$default((String)this.lineSuffix, (String)other.lineSuffix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)this.linePrefix, (String)other.linePrefix, (boolean)false, (int)2, null);
    }

    public final int component1() {
        return this.documentPrefixHash;
    }

    public final int component2() {
        return this.documentPostfixHash;
    }

    @NotNull
    public final String component3() {
        return this.linePrefix;
    }

    @NotNull
    public final String component4() {
        return this.lineSuffix;
    }

    @NotNull
    public final String component5() {
        return this.filePath;
    }

    @NotNull
    public final LightweightCacheKey copy(int documentPrefixHash, int documentPostfixHash, @NotNull String linePrefix, @NotNull String lineSuffix, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)linePrefix, (String)"linePrefix");
        Intrinsics.checkNotNullParameter((Object)lineSuffix, (String)"lineSuffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new LightweightCacheKey(documentPrefixHash, documentPostfixHash, linePrefix, lineSuffix, filePath);
    }

    public static /* synthetic */ LightweightCacheKey copy$default(LightweightCacheKey lightweightCacheKey, int n, int n2, String string, String string2, String string3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = lightweightCacheKey.documentPrefixHash;
        }
        if ((n3 & 2) != 0) {
            n2 = lightweightCacheKey.documentPostfixHash;
        }
        if ((n3 & 4) != 0) {
            string = lightweightCacheKey.linePrefix;
        }
        if ((n3 & 8) != 0) {
            string2 = lightweightCacheKey.lineSuffix;
        }
        if ((n3 & 0x10) != 0) {
            string3 = lightweightCacheKey.filePath;
        }
        return lightweightCacheKey.copy(n, n2, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "LightweightCacheKey(documentPrefixHash=" + this.documentPrefixHash + ", documentPostfixHash=" + this.documentPostfixHash + ", linePrefix=" + this.linePrefix + ", lineSuffix=" + this.lineSuffix + ", filePath=" + this.filePath + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.documentPrefixHash);
        result = result * 31 + Integer.hashCode(this.documentPostfixHash);
        result = result * 31 + this.linePrefix.hashCode();
        result = result * 31 + this.lineSuffix.hashCode();
        result = result * 31 + this.filePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LightweightCacheKey)) {
            return false;
        }
        LightweightCacheKey lightweightCacheKey = (LightweightCacheKey)other;
        if (this.documentPrefixHash != lightweightCacheKey.documentPrefixHash) {
            return false;
        }
        if (this.documentPostfixHash != lightweightCacheKey.documentPostfixHash) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linePrefix, (Object)lightweightCacheKey.linePrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineSuffix, (Object)lightweightCacheKey.lineSuffix)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePath, (Object)lightweightCacheKey.filePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002J2\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u000b0\u0010*\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0014\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$Companion;", "", "<init>", "()V", "build", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "subSequenceAfter", "", "start", "subSequenceBefore", "end", "splitByCurrentLine", "Lkotlin/Triple;", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/editor/Document;", "getTextSafe", "of", "(Lcom/intellij/openapi/editor/Editor;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofBlocking", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        private final LightweightCacheKey build(Editor editor, int offset) {
            ProgressManager.checkCanceled();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Triple<CharSequence, Pair<String, String>, CharSequence> triple = this.splitByCurrentLine(document, offset);
            CharSequence prefix = (CharSequence)triple.component1();
            Pair middle = (Pair)triple.component2();
            CharSequence postfix = (CharSequence)triple.component3();
            int n = prefix.hashCode();
            int n2 = postfix.hashCode();
            String string = (String)middle.getFirst();
            String string2 = (String)middle.getSecond();
            String string3 = editor.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            return new LightweightCacheKey(n, n2, string, string2, string3);
        }

        private final CharSequence subSequenceAfter(CharSequence $this$subSequenceAfter, int start) {
            return StringsKt.subSequence((CharSequence)$this$subSequenceAfter, (IntRange)RangesKt.until((int)start, (int)$this$subSequenceAfter.length()));
        }

        private final CharSequence subSequenceBefore(CharSequence $this$subSequenceBefore, int end) {
            return StringsKt.subSequence((CharSequence)$this$subSequenceBefore, (IntRange)RangesKt.until((int)0, (int)end));
        }

        private final Triple<CharSequence, Pair<String, String>, CharSequence> splitByCurrentLine(Document $this$splitByCurrentLine, int offset) {
            TextRange textRange = DocumentUtil.getLineTextRange((Document)$this$splitByCurrentLine, (int)$this$splitByCurrentLine.getLineNumber(offset));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLineTextRange(...)");
            TextRange range = textRange;
            String linePrefix = StringsKt.removeSuffix((String)this.getTextSafe($this$splitByCurrentLine, range.getStartOffset(), offset), (CharSequence)"\n");
            String lineSuffix = this.getTextSafe($this$splitByCurrentLine, offset, range.getEndOffset());
            CharSequence charSequence = $this$splitByCurrentLine.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence charSequence2 = this.subSequenceBefore(charSequence, range.getStartOffset());
            Pair pair = TuplesKt.to((Object)linePrefix, (Object)lineSuffix);
            CharSequence charSequence3 = $this$splitByCurrentLine.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getCharsSequence(...)");
            return new Triple((Object)charSequence2, (Object)pair, (Object)this.subSequenceAfter(charSequence3, range.getEndOffset()));
        }

        private final String getTextSafe(Document $this$getTextSafe, int start, int end) {
            if (start >= end) {
                return "";
            }
            String string = $this$getTextSafe.getText(new TextRange(start, end));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        @Nullable
        public final Object of(@NotNull Editor editor, int offset, @NotNull Continuation<? super LightweightCacheKey> $completion) {
            return CoroutinesKt.readAction(() -> Companion.of$lambda$0(editor, offset), $completion);
        }

        @NotNull
        public final LightweightCacheKey ofBlocking(@NotNull Editor editor, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (LightweightCacheKey)ActionsKt.runReadAction(() -> Companion.ofBlocking$lambda$1(editor, offset));
        }

        @Nullable
        public final Object of(@NotNull Editor editor, @NotNull Continuation<? super LightweightCacheKey> $completion) {
            return CoroutinesKt.readAction(() -> Companion.of$lambda$2(editor), $completion);
        }

        @NotNull
        public final LightweightCacheKey ofBlocking(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (LightweightCacheKey)ActionsKt.runReadAction(() -> Companion.ofBlocking$lambda$3(editor));
        }

        private static final LightweightCacheKey of$lambda$0(Editor $editor, int $offset) {
            return Companion.build($editor, $offset);
        }

        private static final LightweightCacheKey ofBlocking$lambda$1(Editor $editor, int $offset) {
            return Companion.build($editor, $offset);
        }

        private static final LightweightCacheKey of$lambda$2(Editor $editor) {
            return Companion.build($editor, $editor.getCaretModel().getOffset());
        }

        private static final LightweightCacheKey ofBlocking$lambda$3(Editor $editor) {
            return Companion.build($editor, $editor.getCaretModel().getOffset());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

