/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.TriConsumer;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.FollowingCommentBinder;
import com.jetbrains.python.parsing.LeadingCommentsBinder;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLazyParser
extends PyParser {
    private static final Logger LOG = Logger.getInstance(PyLazyParser.class);

    public static void parseStatementList(IElementType root, SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        SyntaxTreeBuilder.Marker rootMarker = builder.mark();
        ParsingContext context = new ParsingContext(builder, languageLevel);
        StatementParsing statementParser = context.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        context.pushScope(context.emptyParsingScope());
        LazyStatementParsing lazyStatementParsing = new LazyStatementParsing(context);
        lazyStatementParsing.lazyParseStatementList();
        rootMarker.done(root);
        rootMarker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)LeadingCommentsBinder.INSTANCE, (WhitespacesAndCommentsBinder)FollowingCommentBinder.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ASTNode parseLazyElement(@NotNull IElementType rootElement, @NotNull PsiBuilder builder, @NotNull LanguageLevel languageLevel, @NotNull TriConsumer<? super IElementType, ? super SyntaxTreeBuilder, ? super LanguageLevel> parsingFunction) {
        long start;
        block10: {
            ASTNode aSTNode;
            if (rootElement == null) {
                PyLazyParser.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                PyLazyParser.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                PyLazyParser.$$$reportNull$$$0(2);
            }
            if (parsingFunction == null) {
                PyLazyParser.$$$reportNull$$$0(3);
            }
            start = System.currentTimeMillis();
            parsingFunction.accept((Object)rootElement, (Object)builder, (Object)languageLevel);
            try {
                if (builder.eof()) break block10;
                LOG.debug("Lazy parseable element of type " + rootElement + "ends before EOF");
                aSTNode = null;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    long diff = System.currentTimeMillis() - start;
                    double kb = (double)builder.getCurrentOffset() / 1000.0;
                    LOG.debug("Parsed " + String.format("%.1f", kb) + "K file in " + diff + "ms");
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                long diff = System.currentTimeMillis() - start;
                double kb = (double)builder.getCurrentOffset() / 1000.0;
                LOG.debug("Parsed " + String.format("%.1f", kb) + "K file in " + diff + "ms");
            }
            return aSTNode;
        }
        ASTNode ast = builder.getTreeBuilt();
        ASTNode aSTNode = ast.getFirstChildNode();
        if (LOG.isDebugEnabled()) {
            long diff = System.currentTimeMillis() - start;
            double kb = (double)builder.getCurrentOffset() / 1000.0;
            LOG.debug("Parsed " + String.format("%.1f", kb) + "K file in " + diff + "ms");
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "languageLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "parsingFunction";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/parsing/PyLazyParser";
        objectArray[2] = "parseLazyElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LazyStatementParsing
    extends StatementParsing {
        LazyStatementParsing(ParsingContext context) {
            super(context);
        }

        public void lazyParseStatementList() {
            boolean indentFound;
            boolean bl = indentFound = this.myBuilder.getTokenType() == PyTokenTypes.INDENT;
            if (indentFound) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.eof()) {
                    this.myBuilder.error(PyParsingBundle.message("expected.statement", new Object[0]));
                }
                while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != PyTokenTypes.DEDENT) {
                    this.parseStatement();
                }
                if (!this.myBuilder.eof()) {
                    assert (this.myBuilder.getTokenType() == PyTokenTypes.DEDENT);
                    this.myBuilder.advanceLexer();
                }
            } else if (this.myBuilder.eof()) {
                this.myBuilder.error(PyParsingBundle.message("expected.statement", new Object[0]));
            } else {
                ParsingContext context = this.getParsingContext();
                context.pushScope(context.getScope().withSuite());
                this.parseSimpleStatement();
                context.popScope();
                while (this.matchToken(PyTokenTypes.SEMICOLON) && !this.matchToken(PyTokenTypes.STATEMENT_BREAK)) {
                    context.pushScope(context.getScope().withSuite());
                    this.parseSimpleStatement();
                    context.popScope();
                }
            }
        }
    }
}

