/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PyStringLiteralLexerBase;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class PyStringLiteralLexer
extends PyStringLiteralLexerBase {
    private static final short BEFORE_FIRST_QUOTE = 0;
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    private int myState;
    private int myLastState;
    private char myQuoteChar;
    private boolean myIsRaw;
    private boolean myIsTriple;

    public PyStringLiteralLexer(IElementType originalLiteralToken) {
        super(originalLiteralToken);
    }

    @Override
    protected void handleStart(@NotNull CharSequence buffer, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexer.$$$reportNull$$$0(0);
        }
        this.myState = initialState;
        this.myLastState = initialState;
        String prefix = PyStringLiteralCoreUtil.getPrefix(buffer, this.myStart);
        this.myIsRaw = PyStringLiteralUtil.isRawPrefix(prefix);
        int quoteOffset = this.myStart + prefix.length();
        char c = buffer.charAt(quoteOffset);
        assert (c == '\"' || c == '\'') : "String must be quoted by single or double quote. Found '" + c + "' in string " + buffer;
        this.myQuoteChar = c;
        this.myIsTriple = buffer.length() > quoteOffset + 2 && buffer.charAt(quoteOffset + 1) == c && buffer.charAt(quoteOffset + 2) == c;
    }

    @Override
    protected boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    protected boolean isUnicodeMode() {
        return PyTokenTypes.UNICODE_NODES.contains(this.myOriginalLiteralToken);
    }

    @Override
    protected boolean isEscapeEnd(int offset) {
        return super.isEscapeEnd(offset) || this.myBuffer.charAt(offset) == this.myQuoteChar;
    }

    @Override
    public void advance() {
        this.myLastState = this.myState;
        super.advance();
    }

    public int getState() {
        return this.myLastState;
    }

    @Override
    protected int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i = start;
        if (this.myBuffer.charAt(i) == '\\') {
            LOG.assertTrue(this.myState == 1);
            int end = this.locateEscapeSequence(i);
            if (end == this.myBufferEnd) {
                this.myState = 2;
            }
            return end;
        }
        int quote_limit = this.myIsTriple ? 3 : 1;
        int qcnt = 0;
        while (i < this.myBufferEnd) {
            if (this.myBuffer.charAt(i) == '\\' && !this.isRaw()) {
                return i;
            }
            if (this.myState == 0 && this.myBuffer.charAt(i) == this.myQuoteChar) {
                if (++qcnt == quote_limit) {
                    this.myState = 1;
                    qcnt = 0;
                }
            } else if (!(this.myState != 1 || this.myBuffer.charAt(i) != this.myQuoteChar || this.isRaw() && this.myBuffer.charAt(i - 1) == '\\')) {
                if (++qcnt == quote_limit) {
                    this.myState = 2;
                    return i + 1;
                }
            } else {
                qcnt = 0;
            }
            ++i;
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/python/lexer/PyStringLiteralLexer", "handleStart"));
    }
}

