/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipResourceFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PathClassLoader
extends UrlClassLoader {
    static final Function<Path, ResourceFile> RESOURCE_FILE_FACTORY;
    private static final boolean isParallelCapable;
    private BytecodeTransformer transformer;

    public PathClassLoader(@NotNull UrlClassLoader.Builder builder) {
        if (builder == null) {
            PathClassLoader.$$$reportNull$$$0(0);
        }
        super(builder, RESOURCE_FILE_FACTORY, isParallelCapable);
    }

    public void reset(Collection<Path> newClassPath) {
        this.classPath.reset(newClassPath);
    }

    public static Function<Path, ResourceFile> getResourceFileFactory() {
        return RESOURCE_FILE_FACTORY;
    }

    public void setTransformer(BytecodeTransformer transformer) {
        assert (this.transformer == null);
        this.transformer = transformer;
    }

    public PathClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            PathClassLoader.$$$reportNull$$$0(1);
        }
        super(UrlClassLoader.createDefaultBuilderForJdk(parent), RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = null;
        UrlClassLoader.registerInClassLoaderValueMap(parent, this);
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name) {
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(2);
        }
        return this.transformer == null || !this.transformer.isApplicable(name, this);
    }

    @Override
    protected boolean isPackageDefined(String packageName) {
        return this.getDefinedPackage(packageName) != null;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name, byte[] data) throws IOException {
        byte[] transformedData;
        BytecodeTransformer transformer;
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(3);
        }
        if ((transformer = this.transformer) != null && transformer.isApplicable(name, this) && (transformedData = transformer.transform(this, name, data)) != null) {
            return super.consumeClassData(name, transformedData);
        }
        return super.consumeClassData(name, data);
    }

    static {
        boolean defineClassUsingBytes = Boolean.parseBoolean(System.getProperty("idea.define.class.using.byte.array", "false"));
        RESOURCE_FILE_FACTORY = !defineClassUsingBytes && System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows") ? file -> {
            String path = file.toString();
            return new ZipResourceFile((Path)file, path.length() > 2 && path.charAt(0) == '\\' && path.charAt(1) == '\\');
        } : file -> new ZipResourceFile((Path)file, defineClassUsingBytes);
        isParallelCapable = ClassLoader.registerAsParallelCapable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/PathClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isByteBufferSupported";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeClassData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BytecodeTransformer {
        default public boolean isApplicable(String className, ClassLoader loader) {
            return true;
        }

        public byte @Nullable [] transform(ClassLoader var1, String var2, byte[] var3);
    }
}

