/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.services;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.station.comms.common.netty.server.NettyServicesServerBase;
import com.intellij.station.core.IdeServicesHostApplication;
import com.intellij.station.core.discovery.DefaultDiscoveryService;
import com.intellij.station.core.services.IdeStationServicesClient;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/station/core/services/IdeStationServerService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "discoveryService", "Lcom/intellij/station/core/discovery/DefaultDiscoveryService;", "getDiscoveryService", "()Lcom/intellij/station/core/discovery/DefaultDiscoveryService;", "servicesServerBase", "Lcom/intellij/station/comms/common/netty/server/NettyServicesServerBase;", "Companion", "intellij.station.core"})
@SourceDebugExtension(value={"SMAP\nIdeStationServerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeStationServerService.kt\ncom/intellij/station/core/services/IdeStationServerService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,35:1\n24#2:36\n*S KotlinDebug\n*F\n+ 1 IdeStationServerService.kt\ncom/intellij/station/core/services/IdeStationServerService\n*L\n17#1:36\n*E\n"})
public final class IdeStationServerService {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final DefaultDiscoveryService discoveryService;
    @Nullable
    private final NettyServicesServerBase servicesServerBase;
    @NotNull
    private static final Logger logger;

    public IdeStationServerService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (Registry.Companion.is("station.core.discovery.service", false)) {
            logger.info("Creating discovery services");
            this.servicesServerBase = new NettyServicesServerBase(scope, IdeServicesHostApplication.Companion.getInstance());
            this.discoveryService = new DefaultDiscoveryService(scope, IdeStationServicesClient.Companion.getInstance());
        } else {
            logger.info("Discovery is disabled");
            this.servicesServerBase = null;
            this.discoveryService = null;
        }
    }

    @Nullable
    public final DefaultDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IdeStationServerService.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/station/core/services/IdeStationServerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/station/core/services/IdeStationServerService;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.station.core"})
    @SourceDebugExtension(value={"SMAP\nIdeStationServerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeStationServerService.kt\ncom/intellij/station/core/services/IdeStationServerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,35:1\n31#2,2:36\n*S KotlinDebug\n*F\n+ 1 IdeStationServerService.kt\ncom/intellij/station/core/services/IdeStationServerService$Companion\n*L\n16#1:36,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeStationServerService getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<IdeStationServerService> serviceClass$iv = IdeStationServerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (IdeStationServerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

