/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.editorconfig.configmanagement.editor.EditorConfigEditorProvider;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorConfigPreviewFile
extends LightVirtualFile
implements CodeStyleSettingsListener {
    private final Project myProject;
    private final String myOriginalPath;
    private final Document myDocument;

    EditorConfigPreviewFile(@NotNull Project project, @NotNull VirtualFile originalFile, @NotNull Document document, @NotNull Disposable disposable) {
        if (project == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(1);
        }
        if (document == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(3);
        }
        super(originalFile.getName());
        this.myProject = project;
        this.myOriginalPath = originalFile.getPath();
        this.myDocument = document;
        Language language = EditorConfigEditorProvider.Companion.getLanguage(originalFile);
        if (language != null) {
            super.setLanguage(language);
        }
        super.setContent((Object)this, (CharSequence)this.myDocument.getText(), false);
        this.reformat();
        CodeStyleSettingsManager.getInstance((Project)project).subscribe((CodeStyleSettingsListener)this, disposable);
    }

    @NotNull
    private PsiFile createPsi(@NotNull FileType fileType) {
        if (fileType == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("preview", fileType, (CharSequence)this.myDocument.getText(), LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        VirtualFile virtualFile;
        if (event == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(6);
        }
        if ((virtualFile = event.getVirtualFile()) == null || this.isOriginalFile(virtualFile)) {
            this.reformat();
        }
    }

    private boolean isOriginalFile(@NotNull VirtualFile file) {
        if (file == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(7);
        }
        return file.getPath().equals(this.myOriginalPath);
    }

    private void reformat() {
        if (!this.myProject.isInitialized()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiFile originalPsiFile = this.resolveOriginalPsi();
            if (originalPsiFile != null) {
                CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)originalPsiFile);
                PsiFile psiFile = this.createPsi(originalPsiFile.getFileType());
                psiFile.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)originalPsiFile);
                CodeStyle.runWithLocalSettings((Project)this.myProject, (CodeStyleSettings)settings, () -> CodeStyleManager.getInstance((Project)this.myProject).reformatText(psiFile, 0, psiFile.getTextLength()));
                this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)psiFile.getText());
            }
        }), EditorConfigBundle.message("command.name.reformat"), null);
    }

    @Nullable
    public PsiFile resolveOriginalPsi() {
        Document document;
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(this.myOriginalPath, new String[0]), (boolean)true);
        if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOriginalFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

