/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import com.intellij.searchEverywhereMl.settings.SearchEverywhereMlSettings;
import com.intellij.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0019\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\"H\u0001\u00a2\u0006\u0002\b#R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "", "<init>", "()V", "value", "", "isExperimentalMode", "()Z", "setExperimentalMode", "(Z)V", "tabsWithEnabledLogging", "", "", "tabExperiments", "Ljava/util/HashMap;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTabWithMlRanking;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "Lkotlin/collections/HashMap;", "isAllowed", "experimentGroup", "", "getExperimentGroup", "()I", "computedGroup", "getComputedGroup", "computedGroup$delegate", "Lkotlin/Lazy;", "isLoggingEnabledForTab", "tabId", "isDisableExperiments", "tab", "getExperimentForTab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "getTabExperiments", "", "getTabExperiments$intellij_searchEverywhereMl", "Companion", "ExperimentType", "Experiment", "intellij.searchEverywhereMl"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMlExperiment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMlExperiment.kt\ncom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,117:1\n40#2,3:118\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMlExperiment.kt\ncom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment\n*L\n87#1:118,3\n*E\n"})
public final class SearchEverywhereMlExperiment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isExperimentalMode = StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();
    @NotNull
    private final Set<String> tabsWithEnabledLogging;
    @NotNull
    private final HashMap<SearchEverywhereTabWithMlRanking, Experiment> tabExperiments;
    @NotNull
    private final Lazy computedGroup$delegate;
    public static final int VERSION = 2;
    public static final int NUMBER_OF_GROUPS = 4;

    public SearchEverywhereMlExperiment() {
        Object[] objectArray = new String[]{SearchEverywhereTabWithMlRanking.ACTION.getTabId(), SearchEverywhereTabWithMlRanking.FILES.getTabId(), SearchEverywhereTabWithMlRanking.CLASSES.getTabId(), SearchEverywhereTabWithMlRanking.SYMBOLS.getTabId(), SearchEverywhereTabWithMlRanking.ALL.getTabId()};
        this.tabsWithEnabledLogging = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[5];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.ENABLE_TYPOS))};
        objectArray[0] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ACTION), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[1] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.FILES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[2] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.CLASSES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH))};
        objectArray[3] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.SYMBOLS), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL))};
        objectArray[4] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ALL), (Object)new Experiment(pairArray));
        this.tabExperiments = MapsKt.hashMapOf((Pair[])objectArray);
        this.computedGroup$delegate = LazyKt.lazy(SearchEverywhereMlExperiment::computedGroup_delegate$lambda$0);
    }

    public final boolean isExperimentalMode() {
        return this.isExperimentalMode;
    }

    @TestOnly
    public final void setExperimentalMode(boolean bl) {
        this.isExperimentalMode = bl;
    }

    public final boolean isAllowed() {
        return this.isExperimentalMode && !Registry.Companion.is("search.everywhere.force.disable.logging.ml");
    }

    public final int getExperimentGroup() {
        int registryExperimentGroup;
        return this.isExperimentalMode ? ((registryExperimentGroup = Registry.Companion.intValue("search.everywhere.ml.experiment.group", -1, -1, 3)) >= 0 ? registryExperimentGroup : this.getComputedGroup()) : -1;
    }

    private final int getComputedGroup() {
        Lazy lazy = this.computedGroup$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final boolean isLoggingEnabledForTab(@NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        return this.tabsWithEnabledLogging.contains(tabId);
    }

    private final boolean isDisableExperiments(SearchEverywhereTabWithMlRanking tab) {
        String string = tab.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return Registry.Companion.is("search.everywhere.force.disable.experiment." + string + ".ml");
    }

    @NotNull
    public final ExperimentType getExperimentForTab(@NotNull SearchEverywhereTabWithMlRanking tab) {
        ExperimentType experimentByGroup;
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        boolean $i$f$service = false;
        Class<SearchEverywhereMlSettings> serviceClass$iv = SearchEverywhereMlSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SearchEverywhereMlSettings settings = (SearchEverywhereMlSettings)object;
        if (!this.isAllowed() || this.isDisableExperiments(tab)) {
            settings.disableExperiment(tab);
            return ExperimentType.NO_EXPERIMENT;
        }
        Experiment experiment = this.tabExperiments.get((Object)tab);
        ExperimentType experimentType = experimentByGroup = experiment != null ? experiment.getExperimentByGroup(this.getExperimentGroup()) : null;
        if (experimentByGroup == null || experimentByGroup == ExperimentType.NO_EXPERIMENT) {
            settings.disableExperiment(tab);
            return ExperimentType.NO_EXPERIMENT;
        }
        boolean enabledMlRanking = experimentByGroup != ExperimentType.NO_ML && experimentByGroup != ExperimentType.NO_ML_FEATURES;
        boolean isExperimentAllowed = settings.updateExperimentStateIfAllowed(tab, enabledMlRanking);
        return isExperimentAllowed ? experimentByGroup : ExperimentType.NO_EXPERIMENT;
    }

    @TestOnly
    @NotNull
    public final Map<SearchEverywhereTabWithMlRanking, Experiment> getTabExperiments$intellij_searchEverywhereMl() {
        return this.tabExperiments;
    }

    private static final int computedGroup_delegate$lambda$0() {
        EventLogRecorderConfiguration mlseLogConfiguration = EventLogConfiguration.getOrCreate$default((EventLogConfiguration)EventLogConfiguration.Companion.getInstance(), (String)"MLSE", null, (int)2, null);
        return MathUtil.nonNegativeAbs((int)(mlseLogConfiguration.getDeviceId() + "2").hashCode()) % 4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Companion;", "", "<init>", "()V", "VERSION", "", "NUMBER_OF_GROUPS", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B3\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "", "experiments", "", "Lkotlin/Pair;", "", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "<init>", "([Lkotlin/Pair;)V", "tabExperiments", "", "getTabExperiments", "()Ljava/util/Map;", "getExperimentByGroup", "group", "intellij.searchEverywhereMl"})
    @VisibleForTesting
    public static final class Experiment {
        @NotNull
        private final Map<Integer, ExperimentType> tabExperiments;

        public Experiment(Pair<Integer, ? extends ExperimentType> ... experiments) {
            Intrinsics.checkNotNullParameter(experiments, (String)"experiments");
            this.tabExperiments = MapsKt.hashMapOf(Arrays.copyOf(experiments, experiments.length));
        }

        @NotNull
        public final Map<Integer, ExperimentType> getTabExperiments() {
            return this.tabExperiments;
        }

        @NotNull
        public final ExperimentType getExperimentByGroup(int group) {
            return this.tabExperiments.getOrDefault(group, ExperimentType.NO_EXPERIMENT);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "", "<init>", "(Ljava/lang/String;I)V", "NO_EXPERIMENT", "NO_ML", "USE_EXPERIMENTAL_MODEL", "NO_ML_FEATURES", "ENABLE_TYPOS", "ENABLE_SEMANTIC_SEARCH", "intellij.searchEverywhereMl"})
    public static final class ExperimentType
    extends Enum<ExperimentType> {
        public static final /* enum */ ExperimentType NO_EXPERIMENT = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML = new ExperimentType();
        public static final /* enum */ ExperimentType USE_EXPERIMENTAL_MODEL = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML_FEATURES = new ExperimentType();
        public static final /* enum */ ExperimentType ENABLE_TYPOS = new ExperimentType();
        public static final /* enum */ ExperimentType ENABLE_SEMANTIC_SEARCH = new ExperimentType();
        private static final /* synthetic */ ExperimentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExperimentType[] values() {
            return (ExperimentType[])$VALUES.clone();
        }

        public static ExperimentType valueOf(String value) {
            return Enum.valueOf(ExperimentType.class, value);
        }

        @NotNull
        public static EnumEntries<ExperimentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = experimentTypeArray = new ExperimentType[]{ExperimentType.NO_EXPERIMENT, ExperimentType.NO_ML, ExperimentType.USE_EXPERIMENTAL_MODEL, ExperimentType.NO_ML_FEATURES, ExperimentType.ENABLE_TYPOS, ExperimentType.ENABLE_SEMANTIC_SEARCH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

