/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementFactoryImpl;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ImageUtils;", "", "<init>", "()V", "createMarkdownImageText", "", "description", "path", "title", "createHtmlImageText", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "nonEmptyAttribute", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "name", "value", "createImageTagFromText", "Lcom/intellij/psi/xml/XmlTag;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.images"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageUtils.kt\norg/intellij/plugins/markdown/images/editor/ImageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE = new ImageUtils();

    private ImageUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String createMarkdownImageText(@NotNull String description, @NotNull String path, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        String actualTitle = ((CharSequence)title).length() > 0 ? " " + XmlElementFactoryImpl.quoteValue((String)title) : title;
        return "![" + description + "](" + path + actualTitle + ")";
    }

    public static /* synthetic */ String createMarkdownImageText$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        return ImageUtils.createMarkdownImageText(string, string2, string3);
    }

    @JvmStatic
    @NotNull
    public static final String createHtmlImageText(@NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        String path = imageData.component1();
        String width = imageData.component2();
        String height = imageData.component3();
        String title = imageData.component4();
        String description = imageData.component5();
        HtmlChunk.Element element2 = HtmlChunk.tag((String)"img");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"tag(...)");
        HtmlChunk.Element element3 = INSTANCE.nonEmptyAttribute(INSTANCE.nonEmptyAttribute(INSTANCE.nonEmptyAttribute(INSTANCE.nonEmptyAttribute(INSTANCE.nonEmptyAttribute(element2, "src", path), "width", width), "height", height), "title", title), "alt", description);
        String string = element3.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk.Element nonEmptyAttribute(HtmlChunk.Element $this$nonEmptyAttribute, String name, String value) {
        HtmlChunk.Element element2;
        if (((CharSequence)value).length() > 0) {
            HtmlChunk.Element element3 = $this$nonEmptyAttribute.attr(name, value);
            element2 = element3;
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"attr(...)");
        } else {
            element2 = $this$nonEmptyAttribute;
        }
        return element2;
    }

    @JvmStatic
    @Nullable
    public static final XmlTag createImageTagFromText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element2), (Object)MarkdownTokenTypes.HTML_TAG)) {
            return null;
        }
        try {
            XmlTag tag;
            XmlTag xmlTag;
            XmlTag xmlTag2 = XmlElementFactory.getInstance((Project)element2.getProject()).createTagFromText((CharSequence)element2.getText(), (Language)HTMLLanguage.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"createTagFromText(...)");
            XmlTag it = xmlTag = (tag = xmlTag2);
            boolean bl = false;
            return Intrinsics.areEqual((Object)it.getName(), (Object)"img") ? xmlTag : null;
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
    }
}

