/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.MutableAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class MutableAttributeImpl
implements MutableAttribute {
    private final String name;
    private final char valueListDelimiter;
    private final char valueNameDelimiter;
    private String value;
    private LinkedHashMap<String, String> values;

    private MutableAttributeImpl(CharSequence name, CharSequence value2, char valueListDelimiter, char valueNameDelimiter) {
        this.name = String.valueOf(name);
        this.valueListDelimiter = valueListDelimiter;
        this.valueNameDelimiter = valueNameDelimiter;
        this.value = value2 == null ? "" : String.valueOf(value2);
        this.values = null;
    }

    @Override
    public char getValueListDelimiter() {
        return this.valueListDelimiter;
    }

    @Override
    public char getValueNameDelimiter() {
        return this.valueNameDelimiter;
    }

    @Override
    public Attribute toImmutable() {
        return AttributeImpl.of(this);
    }

    @Override
    public MutableAttribute toMutable() {
        return this;
    }

    @Override
    public MutableAttribute copy() {
        return MutableAttributeImpl.of(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.valueFromMap();
        }
        return this.value;
    }

    public void resetToValuesMap() {
        if (this.values == null) {
            throw new IllegalStateException("resetToValuesMap called when values is null");
        }
        this.value = null;
    }

    protected Map<String, String> getValueMap() {
        if (this.values == null) {
            this.values = new LinkedHashMap();
            if (this.valueListDelimiter != '\u0000') {
                if (!this.value.isEmpty()) {
                    int lastPos = 0;
                    while (lastPos < this.value.length()) {
                        int endPos;
                        int pos = this.value.indexOf(this.valueListDelimiter, lastPos);
                        int n = endPos = pos == -1 ? this.value.length() : pos;
                        if (lastPos < endPos) {
                            int namePos;
                            String value2 = this.value.substring(lastPos, endPos);
                            int n2 = namePos = this.valueNameDelimiter != '\u0000' ? value2.indexOf(this.valueNameDelimiter) : -1;
                            if (namePos == -1) {
                                this.values.put(value2, "");
                            } else {
                                this.values.put(value2.substring(0, namePos), value2.substring(namePos + 1));
                            }
                        }
                        if (pos != -1) {
                            lastPos = endPos + 1;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.values.put(this.value, "");
            }
        }
        return this.values;
    }

    protected String valueFromMap() {
        if (this.valueListDelimiter != '\u0000') {
            StringBuilder sb = new StringBuilder();
            if (this.valueNameDelimiter != '\u0000') {
                String sep = "";
                String del = String.valueOf(this.valueListDelimiter);
                for (Map.Entry<String, String> entry : this.values.entrySet()) {
                    if (entry.getKey().isEmpty()) continue;
                    sb.append(sep);
                    sep = del;
                    sb.append(entry.getKey()).append(this.valueNameDelimiter).append(entry.getValue());
                }
            } else {
                String sep = "";
                String del = String.valueOf(this.valueListDelimiter);
                for (String key : this.values.keySet()) {
                    if (key.isEmpty()) continue;
                    sb.append(sep);
                    sb.append(key);
                    sep = del;
                }
            }
            this.value = sb.toString();
        } else {
            this.value = this.values == null || this.values.isEmpty() ? "" : this.values.keySet().iterator().next();
        }
        return this.value;
    }

    @Override
    public boolean isNonRendering() {
        return this.name.indexOf(32) != -1 || this.value.isEmpty() && NON_RENDERING_WHEN_EMPTY.contains(this.name);
    }

    @Override
    public MutableAttributeImpl replaceValue(CharSequence value2) {
        String useValue;
        String string = useValue = value2 == null ? "" : String.valueOf(value2);
        if (this.value == null || value2 == null || !this.value.equals(useValue)) {
            this.value = useValue;
            this.values = null;
        }
        return this;
    }

    @Override
    public MutableAttributeImpl setValue(CharSequence value2) {
        if (this.valueListDelimiter != '\u0000') {
            if (value2 != null && value2.length() != 0) {
                Map<String, String> valueMap = this.getValueMap();
                this.forEachValue(value2, (itemName, itemValue) -> {
                    if (this.valueNameDelimiter != '\u0000' && itemValue.isEmpty()) {
                        valueMap.remove(itemName);
                    } else {
                        valueMap.put((String)itemName, (String)itemValue);
                    }
                });
                this.value = null;
            }
        } else if (this.value == null || !this.value.contentEquals(value2)) {
            this.value = value2 == null ? "" : String.valueOf(value2);
            this.values = null;
        }
        return this;
    }

    private void forEachValue(CharSequence value2, BiConsumer<String, String> consumer) {
        String useValue = value2 == null ? "" : String.valueOf(value2);
        int lastPos = 0;
        while (lastPos < useValue.length()) {
            String valueItem;
            int endPos;
            int pos = useValue.indexOf(this.valueListDelimiter, lastPos);
            int n = endPos = pos == -1 ? useValue.length() : pos;
            if (lastPos < endPos && !(valueItem = useValue.substring(lastPos, endPos).trim()).isEmpty()) {
                int namePos = this.valueNameDelimiter == '\u0000' ? -1 : valueItem.indexOf(this.valueNameDelimiter);
                String itemName = namePos == -1 ? valueItem : valueItem.substring(0, namePos);
                String itemValue = namePos == -1 ? "" : valueItem.substring(namePos + 1);
                consumer.accept(itemName, itemValue);
            }
            if (pos == -1) break;
            lastPos = endPos + 1;
        }
    }

    @Override
    public MutableAttributeImpl removeValue(CharSequence value2) {
        if (this.valueListDelimiter != '\u0000') {
            if (value2 != null && value2.length() != 0) {
                Map<String, String> valueMap = this.getValueMap();
                boolean[] removed = new boolean[]{false};
                this.forEachValue(value2, (itemName, itemValue) -> {
                    if (valueMap.remove(itemName) != null) {
                        removed[0] = true;
                    }
                });
                if (removed[0]) {
                    this.value = null;
                }
            }
        } else if (this.value == null || !this.value.contentEquals(value2)) {
            this.value = "";
            this.values = null;
        }
        return this;
    }

    @Override
    public boolean containsValue(CharSequence value2) {
        return AttributeImpl.indexOfValue(this.value, value2, this.valueListDelimiter, this.valueNameDelimiter) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.getName())) {
            return false;
        }
        return this.getValue().equals(attribute.getValue());
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.getValue().hashCode();
        return result2;
    }

    public String toString() {
        return "MutableAttributeImpl { name='" + this.name + "', value='" + this.getValue() + "' }";
    }

    public static MutableAttributeImpl of(Attribute other) {
        return MutableAttributeImpl.of(other.getName(), other.getValue(), other.getValueListDelimiter(), other.getValueNameDelimiter());
    }

    public static MutableAttributeImpl of(CharSequence attrName) {
        return MutableAttributeImpl.of(attrName, attrName, '\u0000', '\u0000');
    }

    public static MutableAttributeImpl of(CharSequence attrName, CharSequence value2) {
        return MutableAttributeImpl.of(attrName, value2, '\u0000', '\u0000');
    }

    public static MutableAttributeImpl of(CharSequence attrName, CharSequence value2, char valueListDelimiter) {
        return MutableAttributeImpl.of(attrName, value2, valueListDelimiter, '\u0000');
    }

    public static MutableAttributeImpl of(CharSequence attrName, CharSequence value2, char valueListDelimiter, char valueNameDelimiter) {
        if ("class".contentEquals(attrName)) {
            return new MutableAttributeImpl(attrName, value2, ' ', '\u0000');
        }
        if ("style".contentEquals(attrName)) {
            return new MutableAttributeImpl(attrName, value2, ';', ':');
        }
        return new MutableAttributeImpl(attrName, value2, valueListDelimiter, valueNameDelimiter);
    }
}

