/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacrosOptions;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MacrosNodeRenderer
implements PhasedNodeRenderer {
    private final MacrosOptions options;
    final MacroDefinitionRepository repository;
    private final boolean recheckUndefinedReferences;

    public MacrosNodeRenderer(DataHolder options) {
        this.options = new MacrosOptions(options);
        this.repository = MacrosExtension.MACRO_DEFINITIONS.get(options);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<MacroReference>(MacroReference.class, this::render));
        set.add(new NodeRenderingHandler<MacroDefinitionBlock>(MacroDefinitionBlock.class, this::render));
        return set;
    }

    @Override
    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        return set;
    }

    @Override
    public void renderDocument(@NotNull NodeRendererContext context, @NotNull HtmlWriter html, @NotNull Document document, @NotNull RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler<MacroReference>(MacroReference.class, node -> {
                MacroDefinitionBlock macroDefinitionBlock;
                if (!node.isDefined() && (macroDefinitionBlock = node.getMacroDefinitionBlock(this.repository)) != null) {
                    this.repository.addMacrosReference(macroDefinitionBlock, (MacroReference)node);
                    node.setMacroDefinitionBlock(macroDefinitionBlock);
                    hadNewFootnotes[0] = true;
                }
            }));
            visitor.visit(document);
            if (hadNewFootnotes[0]) {
                this.repository.resolveMacrosOrdinals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(MacroReference node, NodeRendererContext context, HtmlWriter html) {
        MacroDefinitionBlock macroDefinitionBlock = (MacroDefinitionBlock)this.repository.get(this.repository.normalizeKey(node.getText()));
        if (macroDefinitionBlock != null) {
            if (macroDefinitionBlock.hasChildren() && !macroDefinitionBlock.isInExpansion()) {
                try {
                    macroDefinitionBlock.setInExpansion(true);
                    Node child = macroDefinitionBlock.getFirstChild();
                    if (child instanceof Paragraph && child == macroDefinitionBlock.getLastChild()) {
                        if (this.options.sourceWrapMacroReferences) {
                            html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag("span");
                            context.renderChildren(child);
                            html.tag("/span");
                        }
                        context.renderChildren(child);
                    }
                    if (this.options.sourceWrapMacroReferences) {
                        ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag("div")).indent()).line();
                        context.renderChildren(macroDefinitionBlock);
                        ((HtmlWriter)html.unIndent()).tag("/div");
                    }
                    context.renderChildren(macroDefinitionBlock);
                }
                finally {
                    macroDefinitionBlock.setInExpansion(false);
                }
            }
        } else {
            html.text(node.getChars());
        }
    }

    private void render(MacroDefinitionBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new MacrosNodeRenderer(options);
        }
    }
}

