/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.List;

public class BorderSpacingPropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.FS_BORDER_SPACING_HORIZONTAL, CSSName.FS_BORDER_SPACING_VERTICAL};

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        List<PropertyDeclaration> result2 = this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
        if (result2 != null) {
            return result2;
        }
        this.checkValueCount(CSSName.BORDER_SPACING, 1, 2, values.size());
        PropertyDeclaration horizontalSpacing = null;
        PropertyDeclaration verticalSpacing = null;
        if (values.size() == 1) {
            PropertyValue value2 = values.get(0);
            this.checkLengthType(cssName, value2);
            if (value2.getFloatValue() < 0.0f) {
                throw new CSSParseException("border-spacing may not be negative", -1);
            }
            horizontalSpacing = new PropertyDeclaration(CSSName.FS_BORDER_SPACING_HORIZONTAL, value2, important, origin);
            verticalSpacing = new PropertyDeclaration(CSSName.FS_BORDER_SPACING_VERTICAL, value2, important, origin);
        } else {
            PropertyValue horizontal = values.get(0);
            this.checkLengthType(cssName, horizontal);
            if (horizontal.getFloatValue() < 0.0f) {
                throw new CSSParseException("border-spacing may not be negative", -1);
            }
            horizontalSpacing = new PropertyDeclaration(CSSName.FS_BORDER_SPACING_HORIZONTAL, horizontal, important, origin);
            PropertyValue vertical = values.get(1);
            this.checkLengthType(cssName, vertical);
            if (vertical.getFloatValue() < 0.0f) {
                throw new CSSParseException("border-spacing may not be negative", -1);
            }
            verticalSpacing = new PropertyDeclaration(CSSName.FS_BORDER_SPACING_VERTICAL, vertical, important, origin);
        }
        result2 = new ArrayList<PropertyDeclaration>(2);
        result2.add(horizontalSpacing);
        result2.add(verticalSpacing);
        return result2;
    }
}

