/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.Content;
import com.intellij.history.core.HistoryPathFilter;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.RevisionData;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0000\u001aF\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a@\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001aL\u0010!\u001a\u00020\"*\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010#\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0002\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00150$H\u0000\"&\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"allRevisions", "", "Lcom/intellij/history/core/revisions/Revision;", "kotlin.jvm.PlatformType", "Lcom/intellij/history/integration/ui/models/RevisionData;", "getAllRevisions", "(Lcom/intellij/history/integration/ui/models/RevisionData;)Ljava/util/List;", "toRevisionId", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "collectRevisionData", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "", "before", "", "mergeLabelsWithRevisions", "Lcom/intellij/history/integration/ui/models/RevisionItem;", "revisions", "filterContents", "", "", "", "selectionCalculator", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "processContents", "", "processor", "Lcom/intellij/util/PairProcessor;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nRevisionData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevisionData.kt\ncom/intellij/history/integration/ui/models/RevisionDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1557#2:98\n1628#2,3:99\n774#2:102\n865#2,2:103\n1202#2,2:105\n1230#2,4:107\n*S KotlinDebug\n*F\n+ 1 RevisionData.kt\ncom/intellij/history/integration/ui/models/RevisionDataKt\n*L\n21#1:98\n21#1:99,3\n81#1:102\n81#1:103,2\n81#1:105,2\n81#1:107,4\n*E\n"})
public final class RevisionDataKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Revision> getAllRevisions(@NotNull RevisionData $this$allRevisions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$allRevisions, (String)"<this>");
        Iterable iterable = $this$allRevisions.getRevisions();
        Collection collection = CollectionsKt.listOf((Object)$this$allRevisions.getCurrentRevision());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RevisionItem revisionItem = (RevisionItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.revision);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final RevisionId toRevisionId(@NotNull Revision $this$toRevisionId) {
        RevisionId revisionId;
        Intrinsics.checkNotNullParameter((Object)$this$toRevisionId, (String)"<this>");
        if ($this$toRevisionId.getChangeSetId() == null) {
            revisionId = RevisionId.Current.INSTANCE;
        } else {
            Long l = $this$toRevisionId.getChangeSetId();
            Intrinsics.checkNotNull((Object)l);
            revisionId = new RevisionId.ChangeSet(l);
        }
        return revisionId;
    }

    @NotNull
    public static final RevisionData collectRevisionData(@NotNull Project project, @NotNull IdeaGateway gateway, @NotNull LocalHistoryFacade facade, @NotNull RootEntry root, @NotNull VirtualFile file, @Nullable String filter2, boolean before) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        gateway.registerUnsavedDocuments(facade);
        String string = gateway.getPathOrUrl(file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        String path = string;
        List<Revision> list = RevisionsCollector.collect(facade, root, path, project.getLocationHash(), HistoryPathFilter.Companion.create(filter2, project), before);
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        List<RevisionItem> revisionItems = RevisionDataKt.mergeLabelsWithRevisions(list);
        return new RevisionData(new CurrentRevision(root, path), revisionItems);
    }

    public static /* synthetic */ RevisionData collectRevisionData$default(Project project, IdeaGateway ideaGateway, LocalHistoryFacade localHistoryFacade, RootEntry rootEntry, VirtualFile virtualFile, String string, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        return RevisionDataKt.collectRevisionData(project, ideaGateway, localHistoryFacade, rootEntry, virtualFile, string, bl);
    }

    private static final List<RevisionItem> mergeLabelsWithRevisions(List<? extends Revision> revisions) {
        List result = new ArrayList();
        for (Revision revision : CollectionsKt.asReversed(revisions)) {
            if (revision.isLabel()) {
                if (result.isEmpty()) continue;
                ((RevisionItem)CollectionsKt.last((List)result)).labels.addFirst(revision);
                continue;
            }
            result.add(new RevisionItem(revision));
        }
        return CollectionsKt.asReversedMutable((List)result);
    }

    @NotNull
    public static final Set<Long> filterContents(@NotNull LocalHistoryFacade $this$filterContents, @NotNull IdeaGateway gateway, @NotNull VirtualFile file, @NotNull List<? extends Revision> revisions, @NotNull String filter2, boolean before) {
        Intrinsics.checkNotNullParameter((Object)$this$filterContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Set result = new LinkedHashSet();
        RevisionDataKt.processContents($this$filterContents, gateway, file, revisions, before, (PairProcessor<? super Revision, ? super String>)((PairProcessor)(arg_0, arg_1) -> RevisionDataKt.filterContents$lambda$2((arg_0, arg_1) -> RevisionDataKt.filterContents$lambda$1(filter2, result, arg_0, arg_1), arg_0, arg_1)));
        return result;
    }

    @NotNull
    public static final Set<Long> filterContents(@NotNull SelectionCalculator selectionCalculator, @NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)selectionCalculator, (String)"selectionCalculator");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Set result = new LinkedHashSet();
        selectionCalculator.processContents((Function2<? super Long, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> RevisionDataKt.filterContents$lambda$3(filter2, result, arg_0, arg_1)));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final void processContents(@NotNull LocalHistoryFacade $this$processContents, @NotNull IdeaGateway gateway, @NotNull VirtualFile file, @NotNull List<? extends Revision> revisions, boolean before, @NotNull PairProcessor<? super Revision, ? super String> processor) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$processContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Iterable $this$filter$iv = revisions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Revision it = (Revision)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLabel())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Revision bl = (Revision)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(it.getChangeSetId(), element$iv$iv);
        }
        Map revisionMap = destination$iv$iv2;
        if (revisionMap.isEmpty()) {
            return;
        }
        RootEntry rootEntry = ((Revision)CollectionsKt.first((Iterable)revisionMap.values())).getRoot().copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry, (String)"copy(...)");
        RootEntry root = rootEntry;
        String string = gateway.getPathOrUrl(file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        String path = string;
        Revision currentRevision = (Revision)revisionMap.get(null);
        if (currentRevision != null) {
            Entry entry = root.findEntry(path);
            Object object = entry;
            processor.process((Object)currentRevision, object != null && (object = ((Entry)object).getContent()) != null ? ((Content)object).getString(entry, gateway) : null);
        }
        LocalHistoryFacadeKt.processContents($this$processContents, gateway, root, path, (Set)CollectionsKt.filterNotNullTo((Iterable)revisionMap.keySet(), (Collection)new LinkedHashSet()), before, (Function2<? super Long, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> RevisionDataKt.processContents$lambda$6(revisionMap, processor, arg_0, arg_1)));
    }

    private static final boolean filterContents$lambda$1(String $filter, Set $result, Revision revision, String content) {
        Long id;
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        String string = content;
        boolean bl = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)$filter, (boolean)true) : false;
        if (bl && (id = revision.getChangeSetId()) != null) {
            $result.add(id);
        }
        return true;
    }

    private static final boolean filterContents$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final boolean filterContents$lambda$3(String $filter, Set $result, long id, String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (StringsKt.contains((CharSequence)contents, (CharSequence)$filter, (boolean)true)) {
            $result.add(id);
        }
        return true;
    }

    private static final boolean processContents$lambda$6(Map $revisionMap, PairProcessor $processor, long changeSetId, String content) {
        Revision revision = (Revision)$revisionMap.get(changeSetId);
        return revision == null || $processor.process((Object)revision, (Object)content);
    }
}

