/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.RemoteConfigService;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Safe;
import com.intellij.packageChecker.service.Unchecked;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.preview.PackageCheckerLinkHandler;
import com.intellij.packageChecker.toolwindow.preview.PackageHtmlRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.html.A;
import kotlinx.html.ApiKt;
import kotlinx.html.B;
import kotlinx.html.BODY;
import kotlinx.html.CommonAttributeGroupFacade;
import kotlinx.html.DIV;
import kotlinx.html.FlowContent;
import kotlinx.html.FlowOrInteractiveOrPhrasingContent;
import kotlinx.html.FlowOrPhrasingContent;
import kotlinx.html.Gen_attr_traitsKt;
import kotlinx.html.HTML;
import kotlinx.html.HTMLTag;
import kotlinx.html.HtmlBlockTag;
import kotlinx.html.I;
import kotlinx.html.LI;
import kotlinx.html.P;
import kotlinx.html.SPAN;
import kotlinx.html.TABLE;
import kotlinx.html.TD;
import kotlinx.html.TR;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.UL;
import kotlinx.html.Unsafe;
import kotlinx.html.UtilKt;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J/\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\u0002\b\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u000b*\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007J\u0014\u0010\"\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007J\u000e\u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007J0\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0007H\u0007J$\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u0002012\u0006\u0010-\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0007H\u0007J(\u00102\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010-\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007JV\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\f\u00106\u001a\b\u0012\u0004\u0012\u00020%072\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020%072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0007H\u0002J,\u00109\u001a\u00020\u000b*\u00020:2\u0006\u0010-\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\b\u0002\u0010,\u001a\u00020\u001fH\u0002J\u0016\u0010;\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010<\u001a\u00020\u0005H\u0002J\u0014\u0010=\u001a\u00020\u000b*\u00020:2\u0006\u00104\u001a\u00020\u0007H\u0002J\f\u0010>\u001a\u00020\u000b*\u00020:H\u0002J0\u0010?\u001a\u00020\u000b*\u00020:2\u0006\u00105\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010@\u001a\u0004\u0018\u00010\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackageHtmlRenderer;", "", "<init>", "()V", "MAX_NUMBER_OF_PROBLEMS_IN_POPUP", "", "renderVulnerableTitle", "", "vulnerable", "Lcom/intellij/packageChecker/service/Vulnerable;", "packageTitle", "", "Lkotlinx/html/BODY;", "pkg", "Lorg/jetbrains/security/package/Package;", "add", "Lkotlin/Function1;", "Lkotlinx/html/SPAN;", "Lkotlin/ExtensionFunctionType;", "renderSafeTitle", "Lcom/intellij/packageChecker/service/Safe;", "copyrightLogo", "Lkotlinx/html/HtmlBlockTag;", "renderPackageStatusHeader", "packageStatus", "Lcom/intellij/packageChecker/service/PackageStatus;", "COPY_VERSION_REF_DESCRIPTION", "REPORT_FALSE_POSITIVE_DESCRIPTION_PREFIX", "COPY_SAFE_VERSION_TEXT", "FOUR_PROPER_SPACES", "isFalsePositiveUrlDescription", "", "description", "getCveIdFromDescription", "getVulnerabilityList", "vulnerabilities", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "isCallToActionUrlDescription", "urlDescription", "getCallToAction", "getLocalInspectionPopup", "direct", "Lorg/jetbrains/security/VulnerablePackage;", "transitive", "inspectionName", "moduleModelId", "getMaliciousInspectionPopup", "malicious", "Lcom/intellij/packageChecker/service/Malicious;", "getVulnerableApiPopup", "getVulnerabilitiesPopup", "header", "totalSize", "directVulnerabilities", "", "transitiveVulnerabilities", "renderVulnerabilityRows", "Lkotlinx/html/TABLE;", "trimToSize", "size", "generateHeader", "generateFooter", "generateShowAllLink", "pkgCoordinates", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageHtmlRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageHtmlRenderer.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageHtmlRenderer\n+ 2 gen-consumer-tags.kt\nkotlinx/html/Gen_consumer_tagsKt\n+ 3 api.kt\nkotlinx/html/ApiKt\n+ 4 visit.kt\nkotlinx/html/VisitKt\n+ 5 gen-tags-h.kt\nkotlinx/html/Gen_tags_hKt\n+ 6 gen-tag-unions.kt\nkotlinx/html/Gen_tag_unionsKt\n+ 7 gen-tag-groups.kt\nkotlinx/html/Gen_tag_groupsKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 gen-tags-u.kt\nkotlinx/html/Gen_tags_uKt\n+ 10 gen-tags-t.kt\nkotlinx/html/Gen_tags_tKt\n*L\n1#1,281:1\n577#2,3:282\n577#2,3:327\n1174#2,3:360\n577#2,3:395\n577#2,3:429\n79#3:285\n76#3:294\n76#3:298\n76#3:316\n76#3:320\n79#3:330\n76#3:339\n76#3:355\n79#3:363\n76#3:373\n76#3:377\n79#3:398\n76#3:407\n76#3:411\n79#3:432\n76#3:441\n76#3:445\n76#3:466\n76#3:470\n76#3:474\n76#3:482\n76#3:488\n76#3:492\n76#3:503\n76#3:507\n76#3:515\n76#3:519\n76#3:523\n76#3:533\n76#3:537\n76#3:541\n10#4,5:286\n4#4,2:291\n4#4,2:295\n4#4,4:299\n6#4,2:303\n6#4,10:305\n4#4,2:317\n4#4,4:321\n6#4,2:325\n10#4,5:331\n4#4,2:336\n4#4,4:340\n6#4,10:344\n4#4,4:356\n10#4,5:364\n4#4,2:369\n4#4,2:374\n4#4,4:378\n6#4,2:382\n6#4,10:385\n10#4,5:399\n4#4,2:404\n4#4,2:408\n4#4,2:412\n6#4,2:415\n6#4,2:417\n6#4,10:419\n10#4,5:433\n4#4,2:438\n4#4,2:442\n4#4,2:446\n6#4,2:450\n6#4,2:452\n6#4,10:454\n4#4,2:467\n4#4,2:471\n4#4,4:475\n6#4,2:479\n4#4,4:483\n4#4,2:489\n4#4,4:493\n6#4,2:497\n6#4,2:499\n4#4,2:504\n4#4,4:508\n6#4,2:512\n4#4,2:516\n4#4,2:520\n4#4,4:524\n6#4,2:528\n6#4,2:530\n4#4,2:534\n4#4,2:538\n4#4,4:542\n6#4,2:546\n6#4,2:548\n164#5:293\n164#5:338\n164#5:406\n164#5:440\n390#6:297\n317#6:315\n171#6:319\n390#6:376\n390#6:473\n242#6:491\n390#6:540\n52#7:354\n143#7:410\n143#7:444\n125#7:522\n1863#8:371\n1864#8:384\n1062#8:414\n1062#8:448\n1062#8:449\n1863#8:464\n1864#8:501\n31#9:372\n54#10:465\n232#10:469\n232#10:481\n232#10:487\n54#10:502\n232#10:506\n54#10:514\n232#10:518\n54#10:532\n232#10:536\n*S KotlinDebug\n*F\n+ 1 PackageHtmlRenderer.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageHtmlRenderer\n*L\n25#1:282,3\n53#1:327,3\n98#1:360,3\n147#1:395,3\n182#1:429,3\n25#1:285\n26#1:294\n36#1:298\n45#1:316\n47#1:320\n53#1:330\n54#1:339\n67#1:355\n98#1:363\n100#1:373\n101#1:377\n147#1:398\n148#1:407\n149#1:411\n182#1:432\n183#1:441\n184#1:445\n206#1:466\n207#1:470\n209#1:474\n213#1:482\n216#1:488\n219#1:492\n239#1:503\n240#1:507\n251#1:515\n252#1:519\n254#1:523\n265#1:533\n266#1:537\n274#1:541\n25#1:286,5\n25#1:291,2\n26#1:295,2\n36#1:299,4\n26#1:303,2\n25#1:305,10\n45#1:317,2\n47#1:321,4\n45#1:325,2\n53#1:331,5\n53#1:336,2\n54#1:340,4\n53#1:344,10\n67#1:356,4\n98#1:364,5\n98#1:369,2\n100#1:374,2\n101#1:378,4\n100#1:382,2\n98#1:385,10\n147#1:399,5\n147#1:404,2\n148#1:408,2\n149#1:412,2\n149#1:415,2\n148#1:417,2\n147#1:419,10\n182#1:433,5\n182#1:438,2\n183#1:442,2\n184#1:446,2\n184#1:450,2\n183#1:452,2\n182#1:454,10\n206#1:467,2\n207#1:471,2\n209#1:475,4\n207#1:479,2\n213#1:483,4\n216#1:489,2\n219#1:493,4\n216#1:497,2\n206#1:499,2\n239#1:504,2\n240#1:508,4\n239#1:512,2\n251#1:516,2\n252#1:520,2\n254#1:524,4\n252#1:528,2\n251#1:530,2\n265#1:534,2\n266#1:538,2\n274#1:542,4\n266#1:546,2\n265#1:548,2\n26#1:293\n54#1:338\n148#1:406\n183#1:440\n36#1:297\n45#1:315\n47#1:319\n101#1:376\n209#1:473\n219#1:491\n274#1:540\n67#1:354\n149#1:410\n184#1:444\n254#1:522\n99#1:371\n99#1:384\n153#1:414\n188#1:448\n192#1:449\n205#1:464\n205#1:501\n100#1:372\n206#1:465\n207#1:469\n213#1:481\n216#1:487\n239#1:502\n240#1:506\n251#1:514\n252#1:518\n265#1:532\n266#1:536\n*E\n"})
public final class PackageHtmlRenderer {
    @NotNull
    public static final PackageHtmlRenderer INSTANCE = new PackageHtmlRenderer();
    private static final int MAX_NUMBER_OF_PROBLEMS_IN_POPUP = 4;
    @NotNull
    public static final String COPY_VERSION_REF_DESCRIPTION = "#copyCall2action";
    @NotNull
    private static final String REPORT_FALSE_POSITIVE_DESCRIPTION_PREFIX = "#false-positive|";
    @NotNull
    public static final String COPY_SAFE_VERSION_TEXT = "Copy safe version to clipboard";
    @NotNull
    public static final String FOUR_PROPER_SPACES = "&nbsp;&nbsp;&nbsp;&nbsp;";

    private PackageHtmlRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    private final String renderVulnerableTitle(Vulnerable vulnerable) {
        SingleVersion newVersion;
        void $this$visitAndFinalize$iv$iv;
        VulnerablePackage vulnerablePackage = vulnerable.getVulnerablePackage();
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)3, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$renderVulnerableTitle_u24lambda_u242 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$renderVulnerableTitle_u24lambda_u242;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        PackageHtmlRenderer.INSTANCE.packageTitle($this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241, vulnerablePackage.getPkg(), (Function1<? super SPAN, Unit>)renderVulnerableTitle.1.1.1.INSTANCE);
        CallToAction callToAction = vulnerablePackage.getCallToAction();
        SingleVersion singleVersion = newVersion = callToAction != null ? callToAction.getNewVersion() : null;
        if (newVersion != null) {
            void $this$a_u24default$iv;
            $this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241.unaryPlus("Upgrade to " + newVersion.getValue() + FOUR_PROPER_SPACES);
            UtilKt.getBr((Tag)((Tag)$this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241));
            UtilKt.getBr((Tag)((Tag)$this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241));
            FlowOrInteractiveOrPhrasingContent flowOrInteractiveOrPhrasingContent = (FlowOrInteractiveOrPhrasingContent)$this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241;
            String href$iv = COPY_VERSION_REF_DESCRIPTION + newVersion;
            Object target$iv = null;
            Object classes$iv2 = null;
            boolean $i$f$a = false;
            String[] stringArray = new String[]{"href", href$iv, "target", target$iv, "class", classes$iv2};
            Tag $this$visit$iv$iv2 = (Tag)new A(ApiKt.attributesMapOf((String[])stringArray), $this$a_u24default$iv.getConsumer());
            boolean $i$f$visit2 = false;
            Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            boolean $i$f$visitTag3 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            A $this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241_u24lambda_u240 = (A)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl5 = false;
            $this$renderVulnerableTitle_u24lambda_u242_u24lambda_u241_u24lambda_u240.unaryPlus(COPY_SAFE_VERSION_TEXT);
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        }
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    private final void packageTitle(BODY $this$packageTitle, Package pkg, Function1<? super SPAN, Unit> add) {
        FlowOrPhrasingContent $this$span_u24default$iv = (FlowOrPhrasingContent)$this$packageTitle;
        String classes$iv = null;
        boolean $i$f$span = false;
        Tag $this$visit$iv$iv = (Tag)new SPAN(ApiKt.attributesMapOf((String)"class", classes$iv), $this$span_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl = false;
        SPAN $this$packageTitle_u24lambda_u245 = (SPAN)$this$visit_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        $this$packageTitle_u24lambda_u245.unaryPlus("Dependency");
        FlowOrPhrasingContent $this$b_u24default$iv = (FlowOrPhrasingContent)$this$packageTitle_u24lambda_u245;
        String classes$iv2 = null;
        boolean $i$f$b = false;
        Tag $this$visit$iv$iv2 = (Tag)new B(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$b_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        B $this$packageTitle_u24lambda_u245_u24lambda_u244 = (B)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl3 = false;
        $this$packageTitle_u24lambda_u245_u24lambda_u244.unaryPlus(" " + pkg.getHumanReadableCoordinates());
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        add.invoke((Object)$this$packageTitle_u24lambda_u245);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
    }

    static /* synthetic */ void packageTitle$default(PackageHtmlRenderer packageHtmlRenderer, BODY bODY, Package package_, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = PackageHtmlRenderer::packageTitle$lambda$3;
        }
        packageHtmlRenderer.packageTitle(bODY, package_, (Function1<? super SPAN, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderSafeTitle(Safe pkg) {
        void $this$visitAndFinalize$iv$iv;
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)3, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$renderSafeTitle_u24lambda_u247 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$renderSafeTitle_u24lambda_u247;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$renderSafeTitle_u24lambda_u247_u24lambda_u246 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        PackageHtmlRenderer.INSTANCE.packageTitle($this$renderSafeTitle_u24lambda_u247_u24lambda_u246, pkg.getPkg(), (Function1<? super SPAN, Unit>)renderSafeTitle.1.1.1.INSTANCE);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    private final void copyrightLogo(HtmlBlockTag $this$copyrightLogo) {
        String copyright = RemoteConfigService.getCopyright$default(RemoteConfigService.Companion.getInstance(), false, 1, null);
        if (copyright != null) {
            FlowContent $this$div_u24default$iv = (FlowContent)$this$copyrightLogo;
            String classes$iv = null;
            boolean $i$f$div = false;
            Tag $this$visit$iv$iv = (Tag)new DIV(ApiKt.attributesMapOf((String)"class", classes$iv), $this$div_u24default$iv.getConsumer());
            boolean $i$f$visit = false;
            Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
            boolean $i$f$visitTag = false;
            $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
            Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
            boolean bl = false;
            DIV $this$copyrightLogo_u24lambda_u248 = (DIV)$this$visit_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$copyrightLogo_u24lambda_u248), (String)"float:right;");
            ApiKt.unsafe((HTMLTag)((HTMLTag)$this$copyrightLogo_u24lambda_u248), (Function1)((Function1)new Function1<Unsafe, Unit>(copyright){
                final /* synthetic */ String $copyright;
                {
                    this.$copyright = $copyright;
                }

                public final void invoke(Unsafe $this$unsafe) {
                    Intrinsics.checkNotNullParameter((Object)$this$unsafe, (String)"$this$unsafe");
                    $this$unsafe.unaryPlus(this.$copyright);
                }
            }));
            $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        }
    }

    @NotNull
    public final String renderPackageStatusHeader(@NotNull PackageStatus packageStatus) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageStatus, (String)"packageStatus");
        PackageStatus packageStatus2 = packageStatus;
        if (packageStatus2 instanceof Vulnerable) {
            string = this.renderVulnerableTitle((Vulnerable)packageStatus);
        } else if (packageStatus2 instanceof Safe) {
            string = this.renderSafeTitle((Safe)packageStatus);
        } else if (packageStatus2 instanceof Unchecked) {
            string = "Unchecked";
        } else if (packageStatus2 instanceof Malicious) {
            string = "Malicious";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public final boolean isFalsePositiveUrlDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return StringsKt.startsWith$default((String)description, (String)REPORT_FALSE_POSITIVE_DESCRIPTION_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getCveIdFromDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        boolean bl = StringsKt.startsWith$default((String)description, (String)REPORT_FALSE_POSITIVE_DESCRIPTION_PREFIX, (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return StringsKt.drop((String)description, (int)16);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getVulnerabilityList(@NotNull List<Vulnerability> vulnerabilities) {
        void $this$visitAndFinalize$iv$iv;
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        TagConsumer $this$ul_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)2, null);
        String classes$iv = null;
        boolean $i$f$ul = false;
        Tag tag = (Tag)new UL(ApiKt.attributesMapOf((String)"class", classes$iv), $this$ul_u24default$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$ul_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        UL $this$getVulnerabilityList_u24lambda_u2412 = (UL)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)vulnerabilities, (int)10);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$a_u24default$iv;
            Vulnerability vulnerability = (Vulnerability)element$iv;
            boolean bl3 = false;
            UL $this$li_u24default$iv = $this$getVulnerabilityList_u24lambda_u2412;
            String classes$iv2 = null;
            boolean $i$f$li = false;
            Tag $this$visit$iv$iv = (Tag)new LI(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$li_u24default$iv.getConsumer());
            boolean $i$f$visit = false;
            Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
            boolean $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
            Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
            boolean bl4 = false;
            LI $this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = (LI)$this$visit_u24lambda_u240$iv$iv;
            boolean bl5 = false;
            FlowOrInteractiveOrPhrasingContent flowOrInteractiveOrPhrasingContent = (FlowOrInteractiveOrPhrasingContent)$this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
            String href$iv = vulnerability.getReference();
            Object target$iv = null;
            Object classes$iv3 = null;
            boolean $i$f$a = false;
            String[] stringArray = new String[]{"href", href$iv, "target", target$iv, "class", classes$iv3};
            Tag $this$visit$iv$iv2 = (Tag)new A(ApiKt.attributesMapOf((String[])stringArray), $this$a_u24default$iv.getConsumer());
            boolean $i$f$visit2 = false;
            Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            boolean $i$f$visitTag3 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            A $this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = (A)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl6 = false;
            $this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.unaryPlus(vulnerability.getCve());
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(" " + vulnerability.getCvssScore());
            $this$getVulnerabilityList_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(" " + ((Object)StringsKt.trim((CharSequence)vulnerability.getTitle())).toString() + " ");
            $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        }
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$ul_u24default$iv.finalize();
    }

    public final boolean isCallToActionUrlDescription(@NotNull String urlDescription) {
        Intrinsics.checkNotNullParameter((Object)urlDescription, (String)"urlDescription");
        return StringsKt.startsWith$default((String)urlDescription, (String)COPY_VERSION_REF_DESCRIPTION, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getCallToAction(@NotNull String urlDescription) {
        Intrinsics.checkNotNullParameter((Object)urlDescription, (String)"urlDescription");
        return StringsKt.drop((String)urlDescription, (int)16);
    }

    @NlsSafe
    @NotNull
    public final String getLocalInspectionPopup(@Nullable VulnerablePackage direct, @Nullable VulnerablePackage transitive, @NotNull String inspectionName, @Nullable String moduleModelId) {
        String string;
        int totalSize;
        Object transitiveVulnerabilities;
        Object object;
        Object directVulnerabilities;
        Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
        Object object2 = direct;
        if (object2 == null || (object2 = ((VulnerablePackage)object2).getVulnerabilities()) == null || (object2 = CollectionsKt.toSet((Iterable)((Iterable)object2))) == null) {
            object2 = directVulnerabilities = SetsKt.emptySet();
        }
        if ((object = transitive) == null || (object = ((VulnerablePackage)object).getVulnerabilities()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = transitiveVulnerabilities = SetsKt.emptySet();
        }
        if ((totalSize = directVulnerabilities.size() + transitiveVulnerabilities.size()) == 1) {
            string = PackageCheckerBundle.message("inspection.popup.header.single", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{totalSize};
            string = PackageCheckerBundle.message("inspection.popup.header.multiple", objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String header = string2;
        VulnerablePackage vulnerablePackage = direct;
        if (vulnerablePackage == null) {
            vulnerablePackage = transitive;
        }
        Package pkg = vulnerablePackage != null ? vulnerablePackage.getPkg() : null;
        return this.getVulnerabilitiesPopup(header, inspectionName, totalSize, (Set<Vulnerability>)directVulnerabilities, (Set<Vulnerability>)transitiveVulnerabilities, pkg, moduleModelId);
    }

    public static /* synthetic */ String getLocalInspectionPopup$default(PackageHtmlRenderer packageHtmlRenderer, VulnerablePackage vulnerablePackage, VulnerablePackage vulnerablePackage2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return packageHtmlRenderer.getLocalInspectionPopup(vulnerablePackage, vulnerablePackage2, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public final String getMaliciousInspectionPopup(@NotNull Malicious malicious, @NotNull String inspectionName, @Nullable String moduleModelId) {
        void $this$visitAndFinalize$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)malicious, (String)"malicious");
        Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
        List<Vulnerability> risks = malicious.getMaliciousPackage().getVulnerablePackage().getVulnerabilities();
        int totalSize = risks.size();
        if (totalSize == 1) {
            string = PackageCheckerBundle.message("malicious.inspection.popup.header.single", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{totalSize};
            string = PackageCheckerBundle.message("malicious.inspection.popup.header.multiple", objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String header = string2;
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)2, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$getMaliciousInspectionPopup_u24lambda_u2416 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$getMaliciousInspectionPopup_u24lambda_u2416;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        FlowContent $this$table_u24default$iv = (FlowContent)$this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415;
        String classes$iv2 = null;
        boolean $i$f$table = false;
        Tag $this$visit$iv$iv2 = (Tag)new TABLE(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$table_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag3 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TABLE $this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = (TABLE)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl5 = false;
        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414), (String)"border-spacing: 0");
        PackageHtmlRenderer.INSTANCE.generateHeader($this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414, header);
        Iterable $this$sortedByDescending$iv = risks;
        boolean $i$f$sortedByDescending = false;
        List risksToShow = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Vulnerability it = (Vulnerability)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getCvssScore());
                it = (Vulnerability)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getCvssScore()));
            }
        }), (int)4);
        PackageHtmlRenderer.renderVulnerabilityRows$default(INSTANCE, $this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414, inspectionName, risksToShow, false, 4, null);
        PackageHtmlRenderer.INSTANCE.generateShowAllLink($this$getMaliciousInspectionPopup_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414, totalSize, moduleModelId, malicious.getPkg().getCoordinates(), inspectionName);
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    public static /* synthetic */ String getMaliciousInspectionPopup$default(PackageHtmlRenderer packageHtmlRenderer, Malicious malicious, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return packageHtmlRenderer.getMaliciousInspectionPopup(malicious, string, string2);
    }

    @NlsSafe
    @NotNull
    public final String getVulnerableApiPopup(@NotNull List<Vulnerability> vulnerabilities, @NotNull String inspectionName, @Nullable Package pkg) {
        String string;
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
        Set directVulnerabilities = CollectionsKt.toSet((Iterable)vulnerabilities);
        int totalSize = vulnerabilities.size();
        if (totalSize == 1) {
            string = PackageCheckerBundle.message("inspection.popup.header.vulnerable.api.usage.single", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{totalSize};
            string = PackageCheckerBundle.message("inspection.popup.header.vulnerable.api.usage.multiple", objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String header = string2;
        return PackageHtmlRenderer.getVulnerabilitiesPopup$default(this, header, inspectionName, totalSize, directVulnerabilities, null, pkg, null, 80, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getVulnerabilitiesPopup(String header, String inspectionName, int totalSize, Set<Vulnerability> directVulnerabilities, Set<Vulnerability> transitiveVulnerabilities, Package pkg, String moduleModelId) {
        void $this$visitAndFinalize$iv$iv;
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)2, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$getVulnerabilitiesPopup_u24lambda_u2421 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$getVulnerabilitiesPopup_u24lambda_u2421;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        FlowContent $this$table_u24default$iv = (FlowContent)$this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420;
        String classes$iv2 = null;
        boolean $i$f$table = false;
        Tag $this$visit$iv$iv2 = (Tag)new TABLE(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$table_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag3 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TABLE $this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419 = (TABLE)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl5 = false;
        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419), (String)"border-spacing: 0");
        PackageHtmlRenderer.INSTANCE.generateHeader($this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, header);
        Iterable $this$sortedByDescending$iv = directVulnerabilities;
        boolean $i$f$sortedByDescending = false;
        List directToShow = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Vulnerability it = (Vulnerability)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getCvssScore());
                it = (Vulnerability)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getCvssScore()));
            }
        }), (int)4);
        PackageHtmlRenderer.renderVulnerabilityRows$default(INSTANCE, $this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, inspectionName, directToShow, false, 4, null);
        if (directToShow.size() < 4) {
            Iterable $this$sortedByDescending$iv2 = transitiveVulnerabilities;
            boolean $i$f$sortedByDescending2 = false;
            List transitiveToShow = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Vulnerability it = (Vulnerability)b;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(it.getCvssScore());
                    it = (Vulnerability)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getCvssScore()));
                }
            }), (int)(4 - directToShow.size()));
            PackageHtmlRenderer.INSTANCE.renderVulnerabilityRows($this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, inspectionName, transitiveToShow, true);
        }
        Package package_ = pkg;
        PackageHtmlRenderer.INSTANCE.generateShowAllLink($this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419, totalSize, moduleModelId, package_ != null ? package_.getCoordinates() : null, inspectionName);
        PackageHtmlRenderer.INSTANCE.generateFooter($this$getVulnerabilitiesPopup_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419);
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    static /* synthetic */ String getVulnerabilitiesPopup$default(PackageHtmlRenderer packageHtmlRenderer, String string, String string2, int n, Set set, Set set2, Package package_, String string3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n2 & 0x20) != 0) {
            package_ = null;
        }
        if ((n2 & 0x40) != 0) {
            string3 = null;
        }
        return packageHtmlRenderer.getVulnerabilitiesPopup(string, string2, n, set, set2, package_, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderVulnerabilityRows(TABLE $this$renderVulnerabilityRows, String inspectionName, List<Vulnerability> vulnerabilities, boolean transitive) {
        Iterable $this$forEach$iv = vulnerabilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$a_u24default$iv;
            Vulnerability vulnerability = (Vulnerability)element$iv;
            boolean bl = false;
            TABLE $this$tr_u24default$iv = $this$renderVulnerabilityRows;
            String classes$iv = null;
            boolean $i$f$tr = false;
            Tag $this$visit$iv$iv = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv), $this$tr_u24default$iv.getConsumer());
            boolean $i$f$visit = false;
            Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
            boolean $i$f$visitTag = false;
            $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
            Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
            boolean bl2 = false;
            TR $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427 = (TR)$this$visit_u24lambda_u240$iv$iv;
            boolean bl3 = false;
            TR $this$td_u24default$iv = $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427;
            String classes$iv2 = null;
            boolean $i$f$td = false;
            Tag $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            boolean $i$f$visit2 = false;
            Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            boolean $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2423 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl4 = false;
            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2423), (String)"white-space: nowrap");
            FlowOrInteractiveOrPhrasingContent flowOrInteractiveOrPhrasingContent = (FlowOrInteractiveOrPhrasingContent)$this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2423;
            String href$iv = PackageCheckerLinkHandler.LinkHandlerUtil.INSTANCE.buildLink(vulnerability.getReference(), inspectionName);
            Object target$iv = null;
            Object classes$iv3 = null;
            boolean $i$f$a = false;
            String[] stringArray = new String[]{"href", href$iv, "target", target$iv, "class", classes$iv3};
            Tag $this$visit$iv$iv3 = (Tag)new A(ApiKt.attributesMapOf((String[])stringArray), $this$a_u24default$iv.getConsumer());
            boolean $i$f$visit3 = false;
            Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
            boolean $i$f$visitTag3 = false;
            $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
            Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            A $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422 = (A)$this$visit_u24lambda_u240$iv$iv3;
            boolean bl5 = false;
            $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422.unaryPlus(vulnerability.getCve());
            $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$td_u24default$iv = $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427;
            classes$iv2 = null;
            $i$f$td = false;
            $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            $i$f$visit2 = false;
            $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl6 = false;
            $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2424.unaryPlus(String.valueOf(vulnerability.getCvssScore()));
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$td_u24default$iv = $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427;
            classes$iv2 = null;
            $i$f$td = false;
            $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            $i$f$visit2 = false;
            $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl7 = false;
            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426), (String)"white-space: nowrap");
            if (transitive) {
                FlowOrPhrasingContent $this$i_u24default$iv = (FlowOrPhrasingContent)$this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
                String classes$iv4 = null;
                boolean $i$f$i = false;
                Tag $this$visit$iv$iv4 = (Tag)new I(ApiKt.attributesMapOf((String)"class", classes$iv4), $this$i_u24default$iv.getConsumer());
                boolean $i$f$visit4 = false;
                Tag $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
                boolean $i$f$visitTag4 = false;
                $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
                Tag $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
                $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                I $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425 = (I)$this$visit_u24lambda_u240$iv$iv4;
                boolean bl8 = false;
                $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.unaryPlus(PackageCheckerBundle.message("inspection.popup.transitive.prefix", new Object[0]) + " ");
                $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
            }
            $this$renderVulnerabilityRows_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.unaryPlus(((Object)StringsKt.trim((CharSequence)vulnerability.getTitle())).toString());
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        }
    }

    static /* synthetic */ void renderVulnerabilityRows$default(PackageHtmlRenderer packageHtmlRenderer, TABLE tABLE, String string, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        packageHtmlRenderer.renderVulnerabilityRows(tABLE, string, list, bl);
    }

    private final String trimToSize(String $this$trimToSize, int size) {
        int lineFeedIndex = StringsKt.indexOf$default((CharSequence)$this$trimToSize, (String)"\n", (int)0, (boolean)false, (int)6, null);
        if (lineFeedIndex > -1 && lineFeedIndex <= size) {
            String string = $this$trimToSize.substring(0, lineFeedIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return $this$trimToSize.length() > size ? StringsKt.take((String)$this$trimToSize, (int)size) + "..." : $this$trimToSize;
    }

    static /* synthetic */ String trimToSize$default(PackageHtmlRenderer packageHtmlRenderer, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 80;
        }
        return packageHtmlRenderer.trimToSize(string, n);
    }

    private final void generateHeader(TABLE $this$generateHeader, String header) {
        TABLE $this$tr_u24default$iv = $this$generateHeader;
        String classes$iv = null;
        boolean $i$f$tr = false;
        Tag $this$visit$iv$iv = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv), $this$tr_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl = false;
        TR $this$generateHeader_u24lambda_u2430 = (TR)$this$visit_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        TR $this$td_u24default$iv = $this$generateHeader_u24lambda_u2430;
        String classes$iv2 = null;
        boolean $i$f$td = false;
        Tag $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TD $this$generateHeader_u24lambda_u2430_u24lambda_u2429 = (TD)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl3 = false;
        $this$generateHeader_u24lambda_u2430_u24lambda_u2429.setColSpan("3");
        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$generateHeader_u24lambda_u2430_u24lambda_u2429), (String)"white-space: nowrap");
        $this$generateHeader_u24lambda_u2430_u24lambda_u2429.unaryPlus(header);
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
    }

    private final void generateFooter(TABLE $this$generateFooter) {
        String copyright = RemoteConfigService.getCopyright$default(RemoteConfigService.Companion.getInstance(), false, 1, null);
        if (copyright != null) {
            TABLE $this$tr_u24default$iv = $this$generateFooter;
            String classes$iv = null;
            boolean $i$f$tr = false;
            Tag $this$visit$iv$iv = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv), $this$tr_u24default$iv.getConsumer());
            boolean $i$f$visit = false;
            Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
            boolean $i$f$visitTag = false;
            $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
            Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
            boolean bl = false;
            TR $this$generateFooter_u24lambda_u2433 = (TR)$this$visit_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            TR $this$td_u24default$iv = $this$generateFooter_u24lambda_u2433;
            String classes$iv2 = null;
            boolean $i$f$td = false;
            Tag $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            boolean $i$f$visit2 = false;
            Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            boolean $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$generateFooter_u24lambda_u2433_u24lambda_u2432 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl3 = false;
            $this$generateFooter_u24lambda_u2433_u24lambda_u2432.setColSpan("3");
            FlowContent $this$p_u24default$iv = (FlowContent)$this$generateFooter_u24lambda_u2433_u24lambda_u2432;
            String classes$iv3 = null;
            boolean $i$f$p = false;
            Tag $this$visit$iv$iv3 = (Tag)new P(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$p_u24default$iv.getConsumer());
            boolean $i$f$visit3 = false;
            Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
            boolean $i$f$visitTag3 = false;
            $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
            Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            P $this$generateFooter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431 = (P)$this$visit_u24lambda_u240$iv$iv3;
            boolean bl4 = false;
            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$generateFooter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431), (String)("color:" + UIUtil.colorToHex((Color)UIUtil.getLabelInfoForeground()) + "; margin: 0"));
            ApiKt.unsafe((HTMLTag)((HTMLTag)$this$generateFooter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431), (Function1)((Function1)new Function1<Unsafe, Unit>(copyright){
                final /* synthetic */ String $copyright;
                {
                    this.$copyright = $copyright;
                }

                public final void invoke(Unsafe $this$unsafe) {
                    Intrinsics.checkNotNullParameter((Object)$this$unsafe, (String)"$this$unsafe");
                    $this$unsafe.unaryPlus(this.$copyright);
                }
            }));
            $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateShowAllLink(TABLE $this$generateShowAllLink, int totalSize, String moduleModelId, String pkgCoordinates, String inspectionName) {
        void $this$a_u24default$iv;
        String string;
        TABLE $this$tr_u24default$iv = $this$generateShowAllLink;
        String classes$iv = null;
        boolean $i$f$tr = false;
        Tag $this$visit$iv$iv = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv), $this$tr_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl = false;
        TR $this$generateShowAllLink_u24lambda_u2436 = (TR)$this$visit_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        TR $this$td_u24default$iv = $this$generateShowAllLink_u24lambda_u2436;
        String classes$iv2 = null;
        boolean $i$f$td = false;
        Tag $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TD $this$generateShowAllLink_u24lambda_u2436_u24lambda_u2435 = (TD)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl3 = false;
        $this$generateShowAllLink_u24lambda_u2436_u24lambda_u2435.setColSpan("3");
        if (totalSize > 4) {
            var28_28 = new Object[]{totalSize};
            string = PackageCheckerBundle.message("inspection.popup.show.all.hint", var28_28);
        } else {
            var28_28 = new Object[]{totalSize};
            string = PackageCheckerBundle.message("inspection.popup.show.details.hint", var28_28);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String showAll = string2;
        string2 = (FlowOrInteractiveOrPhrasingContent)$this$generateShowAllLink_u24lambda_u2436_u24lambda_u2435;
        String href$iv = PackageCheckerLinkHandler.LinkHandlerUtil.INSTANCE.buildLink(moduleModelId, pkgCoordinates, inspectionName);
        Object target$iv = null;
        Object classes$iv3 = null;
        boolean $i$f$a = false;
        String[] stringArray = new String[]{"href", href$iv, "target", target$iv, "class", classes$iv3};
        Tag $this$visit$iv$iv3 = (Tag)new A(ApiKt.attributesMapOf((String[])stringArray), $this$a_u24default$iv.getConsumer());
        boolean $i$f$visit3 = false;
        Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
        boolean $i$f$visitTag3 = false;
        $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
        Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        A $this$generateShowAllLink_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434 = (A)$this$visit_u24lambda_u240$iv$iv3;
        boolean bl4 = false;
        $this$generateShowAllLink_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.unaryPlus(showAll);
        $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
    }

    private static final Unit packageTitle$lambda$3(SPAN sPAN) {
        Intrinsics.checkNotNullParameter((Object)sPAN, (String)"<this>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$copyrightLogo(PackageHtmlRenderer $this, HtmlBlockTag $receiver) {
        $this.copyrightLogo($receiver);
    }
}

