/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection;

import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelImpl;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"getModuleId", "", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getDeclaredDependencies", "", "Lorg/jetbrains/security/package/Package;", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "service", "Lcom/intellij/packageChecker/service/PackageService;", "findMaliciousPackages", "", "Lcom/intellij/packageChecker/service/Malicious;", "declaredDependencies", "packageChecker", "Lcom/intellij/packageChecker/service/PackageChecker;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nMaliciousLibrariesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaliciousLibrariesUtils.kt\ncom/intellij/packageChecker/inspection/MaliciousLibrariesUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,25:1\n1#2:26\n1#2:43\n1202#3,2:27\n1230#3,4:29\n1611#3,9:33\n1863#3:42\n1864#3:44\n1620#3:45\n*S KotlinDebug\n*F\n+ 1 MaliciousLibrariesUtils.kt\ncom/intellij/packageChecker/inspection/MaliciousLibrariesUtilsKt\n*L\n21#1:43\n16#1:27,2\n16#1:29,4\n21#1:33,9\n21#1:42\n21#1:44\n21#1:45\n*E\n"})
public final class MaliciousLibrariesUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String getModuleId(@NotNull PsiFile file, @NotNull Project project) {
        Object v2;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StateFlow<Set<ModuleModel>> modules = ProjectDependenciesModelImpl.Companion.getInstance(project).getModules();
            Set set = (Set)modules.getValue();
            object = set;
            if (set == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                ModuleModel it = (ModuleModel)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBuildFile(), (Object)file.getVirtualFile())) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        ModuleModel moduleModel = v2;
        object = moduleModel;
        if (moduleModel == null) return null;
        String string = object.getId();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Package, PackageDeclaration> getDeclaredDependencies(@NotNull PsiFile file, @NotNull PackageService service) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Iterable $this$associateBy$iv = service.declaredDependencies(file);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PackageDeclaration packageDeclaration = (PackageDeclaration)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getPkg(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Malicious> findMaliciousPackages(@NotNull Map<Package, PackageDeclaration> declaredDependencies, @NotNull PackageChecker packageChecker) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaredDependencies, (String)"declaredDependencies");
        Intrinsics.checkNotNullParameter((Object)packageChecker, (String)"packageChecker");
        Iterable $this$mapNotNull$iv = declaredDependencies.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Malicious it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Package it = (Package)element$iv$iv;
            boolean bl2 = false;
            PackageStatus packageStatus = packageChecker.packageStatus(it);
            if ((packageStatus instanceof Malicious ? (Malicious)packageStatus : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

