/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CurrentBranchConditionCache;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u0001:\u000501234B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001c\u001a\u00020\u0018H\u0003J\b\u0010\u001d\u001a\u00020\u0019H\u0003J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\rJ\b\u0010!\u001a\u00020\u0019H\u0002J\u001e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*2\u0006\u0010#\u001a\u00020$J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rh\u0010\u000e\u001aZ\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0013 \u0011*\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u0012 \u0011*,\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0013 \u0011*\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter;", "", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/openapi/Disposable;)V", "taskExecutor", "Lcom/intellij/vcs/log/util/SequentialLimitedLifoExecutor;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$CachingTask;", "loadingFinishedListeners", "", "Ljava/lang/Runnable;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/vcs/log/CommitId;", "kotlin.jvm.PlatformType", "", "", "Lcom/github/benmanes/caffeine/cache/Cache;", "conditionsCache", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache;", "currentBranchesChecksum", "", "", "commitId", "branches", "branchesChecksum", "clearCache", "addTaskCompletedListener", "runnable", "removeTaskCompletedListener", "notifyListeners", "requestContainingBranches", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "getContainingBranchesFromCache", "getContainingBranchesQuickly", "getContainedInCurrentBranchCondition", "Ljava/util/function/Predicate;", "getContainingBranchesSynchronously", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "createTask", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "Task", "GraphTask", "ProviderTask", "CachingTask", "Companion", "intellij.platform.vcs.log.impl"})
public final class ContainingBranchesGetter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final SequentialLimitedLifoExecutor<CachingTask> taskExecutor;
    @NotNull
    private final List<Runnable> loadingFinishedListeners;
    private final Cache<CommitId, List<String>> cache;
    @NotNull
    private final CurrentBranchConditionCache conditionsCache;
    private int currentBranchesChecksum;
    @NotNull
    private static final Logger LOG;

    public ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.logData = logData;
        this.loadingFinishedListeners = new ArrayList();
        this.cache = Caffeine.newBuilder().maximumSize(2000L).build();
        this.conditionsCache = new CurrentBranchConditionCache(this.logData, parentDisposable);
        this.taskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, arg_0 -> ContainingBranchesGetter._init_$lambda$0(1.INSTANCE, arg_0));
        this.logData.addDataPackChangeListener(arg_0 -> ContainingBranchesGetter._init_$lambda$1(this, arg_0));
    }

    @RequiresEdt
    private final void cache(CommitId commitId, List<String> branches, int branchesChecksum) {
        if (branchesChecksum == this.currentBranchesChecksum) {
            this.cache.put((Object)commitId, branches);
            this.notifyListeners();
        }
    }

    @RequiresEdt
    private final void clearCache() {
        this.cache.invalidateAll();
        this.taskExecutor.clear();
        this.conditionsCache.clear();
        ApplicationManager.getApplication().invokeLater(() -> ContainingBranchesGetter.clearCache$lambda$2(this));
    }

    public final void addTaskCompletedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.loadingFinishedListeners.add(runnable);
    }

    public final void removeTaskCompletedListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.loadingFinishedListeners.remove(runnable);
    }

    private final void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.loadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public final List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            DataPack dataPack = this.logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
            this.taskExecutor.queue(new CachingTask(this.createTask(root, hash, dataPack), this.currentBranchesChecksum));
        }
        return refs;
    }

    @Nullable
    public final List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.cache.getIfPresent((Object)new CommitId(hash, root));
    }

    @Nullable
    public final List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        int nodeId;
        List cachedBranches;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        List list = cachedBranches = (List)this.cache.getIfPresent((Object)new CommitId(hash, root));
        if (list != null) {
            return list;
        }
        DataPack dataPack = this.logData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
        DataPack dataPack2 = dataPack;
        int commitIndex = this.logData.getCommitIndex(hash, root);
        PermanentGraph<Integer> pg = dataPack2.getPermanentGraph();
        if (pg instanceof PermanentGraphImpl && (nodeId = ((PermanentCommitsInfoImpl)((PermanentGraphImpl)pg).getPermanentCommitsInfo()).getNodeId(commitIndex)) < 10000) {
            VcsLogProvider vcsLogProvider = this.logData.getLogProvider(root);
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogProvider, (String)"getLogProvider(...)");
            if (ContainingBranchesGetter.Companion.canUseGraphForComputation(vcsLogProvider)) {
                return this.getContainingBranchesSynchronously(dataPack2, root, hash);
            }
        }
        return (List)BackgroundTaskUtil.tryComputeFast(arg_0 -> ContainingBranchesGetter.getContainingBranchesQuickly$lambda$4(arg_0 -> ContainingBranchesGetter.getContainingBranchesQuickly$lambda$3(this, dataPack2, root, hash, arg_0), arg_0), (long)100L);
    }

    @NotNull
    public final Predicate<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.conditionsCache.getContainedInCurrentBranchCondition(root);
    }

    @NotNull
    public final List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        DataPack dataPack = this.logData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
        return this.getContainingBranchesSynchronously(dataPack, root, hash);
    }

    private final List<String> getContainingBranchesSynchronously(DataPack dataPack, VirtualFile root, Hash hash) {
        return new CachingTask(this.createTask(root, hash, dataPack), ((Object)dataPack.getRefsModel().getBranches()).hashCode()).run();
    }

    private final Task createTask(VirtualFile root, Hash hash, DataPack dataPack) {
        VcsLogProvider vcsLogProvider = this.logData.getLogProvider(root);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogProvider, (String)"getLogProvider(...)");
        VcsLogProvider provider = vcsLogProvider;
        return ContainingBranchesGetter.Companion.canUseGraphForComputation(provider) ? (Task)new GraphTask(provider, root, hash, dataPack) : (Task)new ProviderTask(provider, root, hash);
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(ContainingBranchesGetter this$0, DataPack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int checksum = ((Object)this$0.logData.getDataPack().getRefsModel().getBranches()).hashCode();
        if (this$0.currentBranchesChecksum != checksum) {
            this$0.clearCache();
        }
        this$0.currentBranchesChecksum = checksum;
    }

    private static final void clearCache$lambda$2(ContainingBranchesGetter this$0) {
        this$0.notifyListeners();
    }

    private static final List getContainingBranchesQuickly$lambda$3(ContainingBranchesGetter this$0, DataPack $dataPack, VirtualFile $root, Hash $hash, ProgressIndicator it) {
        return this$0.getContainingBranchesSynchronously($dataPack, $root, $hash);
    }

    private static final List getContainingBranchesQuickly$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(ContainingBranchesGetter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$CachingTask;", "", "delegate", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "branchesChecksum", "", "<init>", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;I)V", "run", "", "", "intellij.platform.vcs.log.impl"})
    private final class CachingTask {
        @NotNull
        private final Task delegate;
        private final int branchesChecksum;

        public CachingTask(Task delegate, int branchesChecksum) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.branchesChecksum = branchesChecksum;
        }

        @NotNull
        public final List<String> run() {
            List<String> branches = this.delegate.getContainingBranches();
            CommitId commitId = new CommitId(this.delegate.getMyHash(), this.delegate.getMyRoot());
            UIUtil.invokeLaterIfNeeded(() -> CachingTask.run$lambda$0(ContainingBranchesGetter.this, commitId, branches, this));
            return branches;
        }

        private static final void run$lambda$0(ContainingBranchesGetter this$0, CommitId $commitId, List $branches, CachingTask this$1) {
            this$0.cache($commitId, $branches, this$1.branchesChecksum);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "canUseGraphForComputation", "", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean canUseGraphForComputation(VcsLogProvider logProvider) {
            Object object = VcsLogProperties.LIGHTWEIGHT_BRANCHES.getOrDefault(logProvider);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            return (Boolean)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "provider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "<init>", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/data/DataPack;)V", "graph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "", "refs", "Lcom/intellij/vcs/log/data/RefsModel;", "Lorg/jetbrains/annotations/NotNull;", "getContainingBranches", "", "", "getBranchesRefs", "Lcom/intellij/vcs/log/VcsRef;", "branchIndex", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nContainingBranchesGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainingBranchesGetter.kt\ncom/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1557#2:213\n1628#2,3:214\n1557#2:217\n1628#2,3:218\n774#2:221\n865#2,2:222\n*S KotlinDebug\n*F\n+ 1 ContainingBranchesGetter.kt\ncom/intellij/vcs/log/data/ContainingBranchesGetter$GraphTask\n*L\n177#1:213\n177#1:214,3\n180#1:217\n180#1:218,3\n184#1:221\n184#1:222,2\n*E\n"})
    private final class GraphTask
    extends Task {
        @NotNull
        private final PermanentGraph<Integer> graph;
        @NotNull
        private final RefsModel refs;

        public GraphTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash, DataPack dataPack) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            super(provider, root, hash);
            this.graph = dataPack.getPermanentGraph();
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
            this.refs = refsModel;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            int commitIndex = ContainingBranchesGetter.this.logData.getCommitIndex(hash, root);
            Iterable iterable = this.graph.getContainingBranches((Object)commitIndex);
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean $i$f$getContainingBranches$stub_for_inlining = false;
                boolean bl = false;
                collection.add(this.getBranchesRefs((int)p0));
            }
            Iterable iterable2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Comparator comparator = provider.getReferenceManager().getLabelsOrderComparator();
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getLabelsOrderComparator(...)");
            $this$map$iv = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VcsRef p0 = (VcsRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean $i$f$getContainingBranches$stub_for_inlining$0 = false;
                boolean bl = false;
                collection.add(p0.getName());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VcsRef> getBranchesRefs(int branchIndex) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.refs.refsToCommit(branchIndex);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsRef it = (VcsRef)element$iv$iv;
                boolean bl = false;
                if (!it.getType().isBranch()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ.\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$ProviderTask;", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "provider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getContainingBranches", "", "", "kotlin.jvm.PlatformType", "intellij.platform.vcs.log.impl"})
    private static final class ProviderTask
    extends Task {
        public ProviderTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            super(provider, root, hash);
        }

        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Collection collection = provider.getContainingBranches(root, hash);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getContainingBranches(...)");
            return CollectionsKt.sorted((Iterable)collection);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/data/ContainingBranchesGetter$Task;", "", "myProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "myRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "myHash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Lcom/intellij/vcs/log/VcsLogProvider;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getMyRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getMyHash", "()Lcom/intellij/vcs/log/Hash;", "getContainingBranches", "", "", "provider", "root", "hash", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nContainingBranchesGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainingBranchesGetter.kt\ncom/intellij/vcs/log/data/ContainingBranchesGetter$Task\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,212:1\n28#2:213\n88#2,2:214\n29#2,3:216\n101#2:219\n91#2,8:220\n*S KotlinDebug\n*F\n+ 1 ContainingBranchesGetter.kt\ncom/intellij/vcs/log/data/ContainingBranchesGetter$Task\n*L\n152#1:213\n152#1:214,2\n152#1:216,3\n152#1:219\n152#1:220,8\n*E\n"})
    private static abstract class Task {
        @NotNull
        private final VcsLogProvider myProvider;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final Hash myHash;

        public Task(@NotNull VcsLogProvider myProvider, @NotNull VirtualFile myRoot, @NotNull Hash myHash) {
            Intrinsics.checkNotNullParameter((Object)myProvider, (String)"myProvider");
            Intrinsics.checkNotNullParameter((Object)myRoot, (String)"myRoot");
            Intrinsics.checkNotNullParameter((Object)myHash, (String)"myHash");
            this.myProvider = myProvider;
            this.myRoot = myRoot;
            this.myHash = myHash;
        }

        @NotNull
        public final VirtualFile getMyRoot() {
            return this.myRoot;
        }

        @NotNull
        public final Hash getMyHash() {
            return this.myHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<String> getContainingBranches() throws VcsException {
            List<String> list;
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.GettingContainingBranches.getName());
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder $this$use$iv = spanBuilder;
            boolean $i$f$use = false;
            Span span = $this$use$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            Span $this$useWithoutActiveScope$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                List<String> list2;
                Span span$iv = $this$useWithoutActiveScope$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    List<String> list3;
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span it = span$iv;
                    boolean bl3 = false;
                    try {
                        list3 = this.getContainingBranches(this.myProvider, this.myRoot, this.myHash);
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        list3 = CollectionsKt.emptyList();
                    }
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                list = list2;
            }
            catch (CancellationException e$iv$iv) {
                $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                throw e$iv$iv;
            }
            catch (Throwable e$iv$iv) {
                $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv.end();
            }
            return list;
        }

        @NotNull
        protected abstract List<String> getContainingBranches(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull Hash var3) throws VcsException;
    }
}

