/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.youtrack.YouTrackPluginAdvertiserService;
import com.intellij.tasks.youtrack.YouTrackTask;
import com.intellij.tasks.youtrack.model.YouTrackCommandList;
import com.intellij.tasks.youtrack.model.YouTrackErrorInfo;
import com.intellij.tasks.youtrack.model.YouTrackIssue;
import com.intellij.tasks.youtrack.model.YouTrackSingleIssueCommand;
import com.intellij.tasks.youtrack.model.YouTrackWorkItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="YouTrack")
public class YouTrackRepository
extends NewBaseRepositoryImpl {
    private static final TypeToken<List<YouTrackIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<YouTrackIssue>>(){};
    private static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final Logger LOG = Logger.getInstance(YouTrackRepository.class);
    private String myDefaultSearch = "Assignee: me sort by: updated #Unresolved";

    public YouTrackRepository() {
    }

    public YouTrackRepository(TaskRepositoryType type) {
        super(type);
    }

    @Override
    @NotNull
    public BaseRepository clone() {
        return new YouTrackRepository(this);
    }

    private YouTrackRepository(YouTrackRepository other) {
        super(other);
        this.myDefaultSearch = other.getDefaultSearch();
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<YouTrackIssue> result = this.fetchIssues(query, offset, limit);
        return (Task[])ContainerUtil.map2Array(result, YouTrackTask.class, issue -> new YouTrackTask(this, (YouTrackIssue)issue));
    }

    @NotNull
    private List<YouTrackIssue> fetchIssues(@Nullable String query, int offset, int limit) throws URISyntaxException, IOException {
        List list;
        String searchQuery = this.getDefaultSearch() + (String)(StringUtil.isNotEmpty((String)query) ? " " + query : "");
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "issues")).addParameter("query", searchQuery).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").addParameter("$skip", String.valueOf(offset)).addParameter("$top", String.valueOf(limit)).build();
        try {
            list = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(endpoint), TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toMultipleObjects(LIST_OF_ISSUES_TYPE));
        }
        catch (YouTrackRequestFailedException e) {
            if ("invalid_query".equals(e.getErrorInfo().getError())) {
                LOG.debug("Ignoring invalid query: " + searchQuery);
                List<YouTrackIssue> list2 = Collections.emptyList();
                if (list2 == null) {
                    YouTrackRepository.$$$reportNull$$$0(1);
                }
                return list2;
            }
            throw e;
        }
        if (list == null) {
            YouTrackRepository.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                URI endpoint = new URIBuilder(YouTrackRepository.this.getRestApiUrl("api", "issues")).addParameter("query", YouTrackRepository.this.myDefaultSearch).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").addParameter("$top", String.valueOf(10)).build();
                this.myCurrentRequest.setURI(endpoint);
                YouTrackRepository.this.getHttpClient().execute((HttpUriRequest)this.myCurrentRequest, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(YouTrackRepository.this::parseYouTrackError).toNothing());
            }
        };
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        YouTrackIssue issue;
        if (id == null) {
            YouTrackRepository.$$$reportNull$$$0(2);
        }
        return (issue = this.fetchIssue(id)) != null ? new YouTrackTask(this, issue) : null;
    }

    @Nullable
    private YouTrackIssue fetchIssue(@NotNull String issueId) throws URISyntaxException, IOException {
        if (issueId == null) {
            YouTrackRepository.$$$reportNull$$$0(3);
        }
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "issues", issueId)).addParameter("fields", "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))").build();
        return (YouTrackIssue)this.getHttpClient().execute((HttpUriRequest)new HttpGet(endpoint), TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).ignoredCode(code -> code == 404).toSingleObject(YouTrackIssue.class));
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(4);
        }
        if (state == null) {
            YouTrackRepository.$$$reportNull$$$0(5);
        }
        HttpPost request = new HttpPost(this.getRestApiUrl("api", "commands"));
        request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackSingleIssueCommand(task.getId(), "state " + state.getId())), ContentType.APPLICATION_JSON));
        this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toNothing());
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(6);
        }
        Set set = ContainerUtil.map2Set(this.fetchAvailableStates(task.getId()), suggestion -> new CustomTaskState(suggestion, suggestion));
        if (set == null) {
            YouTrackRepository.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private List<String> fetchAvailableStates(@NotNull String issueId) throws URISyntaxException, IOException {
        if (issueId == null) {
            YouTrackRepository.$$$reportNull$$$0(8);
        }
        URI endpoint = new URIBuilder(this.getRestApiUrl("api", "commands", "assist")).addParameter("fields", "suggestions(option)").build();
        String setStateCommandPrefix = "state ";
        HttpPost request = new HttpPost(endpoint);
        request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackSingleIssueCommand(issueId, setStateCommandPrefix)), ContentType.APPLICATION_JSON));
        YouTrackCommandList commandList = (YouTrackCommandList)this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toSingleObject(YouTrackCommandList.class));
        if (commandList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                YouTrackRepository.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull(commandList.getSuggestions(), suggestion -> {
            String option = suggestion.getOption();
            return option.startsWith(setStateCommandPrefix) ? null : option;
        });
        if (list == null) {
            YouTrackRepository.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(11);
        }
        if (timeSpent == null) {
            YouTrackRepository.$$$reportNull$$$0(12);
        }
        if (comment == null) {
            YouTrackRepository.$$$reportNull$$$0(13);
        }
        YouTrackPluginAdvertiserService.getInstance().showTimeTrackingNotification();
        Matcher matcher = TIME_SPENT_PATTERN.matcher(timeSpent);
        if (matcher.find()) {
            int hours = Integer.parseInt(matcher.group(1));
            int minutes = Integer.parseInt(matcher.group(2));
            int totalMinutes = hours * 60 + minutes;
            HttpPost request = new HttpPost(this.getRestApiUrl("api", "issues", task.getId(), "timeTracking", "workItems"));
            request.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)new YouTrackWorkItem(comment, totalMinutes)), ContentType.APPLICATION_JSON));
            this.getHttpClient().execute((HttpUriRequest)request, TaskResponseUtil.JsonResponseHandlerBuilder.fromGson(GSON).errorHandler(this::parseYouTrackError).toNothing());
        } else {
            LOG.warn("Unrecognized time pattern: " + timeSpent);
        }
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return (request, context) -> request.addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_JSON.toString()));
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        if (defaultSearch != null) {
            this.myDefaultSearch = defaultSearch;
        }
    }

    @Override
    @NotNull
    protected HttpClient getHttpClient() {
        HttpClient httpClient = super.getHttpClient();
        if (httpClient == null) {
            YouTrackRepository.$$$reportNull$$$0(14);
        }
        return httpClient;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        YouTrackRepository repository = (YouTrackRepository)((Object)o);
        return Objects.equals(repository.getDefaultSearch(), this.getDefaultSearch());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8 | 4;
    }

    @Override
    @NotNull
    protected String getDefaultScheme() {
        return "https";
    }

    @Override
    public boolean isUseHttpAuthentication() {
        return true;
    }

    @NotNull
    private RequestFailedException parseYouTrackError(@NotNull HttpResponse response) {
        if (response == null) {
            YouTrackRepository.$$$reportNull$$$0(15);
        }
        try {
            return new YouTrackRequestFailedException(this, (YouTrackErrorInfo)GSON.fromJson(TaskResponseUtil.getResponseContentAsReader(response), YouTrackErrorInfo.class));
        }
        catch (IOException e) {
            return new RequestFailedException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 8, 11, 12, 13, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackRepository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueId";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchIssues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackRepository";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAvailableStates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpClient";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fetchIssue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchAvailableStates";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseYouTrackError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 8, 11, 12, 13, 15 -> new IllegalArgumentException(string);
        };
    }

    private static class YouTrackRequestFailedException
    extends RequestFailedException {
        private final YouTrackErrorInfo myErrorInfo;

        private YouTrackRequestFailedException(@NotNull YouTrackRepository repository, @NotNull YouTrackErrorInfo errorInfo) {
            if (repository == null) {
                YouTrackRequestFailedException.$$$reportNull$$$0(0);
            }
            if (errorInfo == null) {
                YouTrackRequestFailedException.$$$reportNull$$$0(1);
            }
            super((TaskRepository)repository, YouTrackRequestFailedException.mostDescriptiveMessage(errorInfo));
            this.myErrorInfo = errorInfo;
        }

        @NotNull
        private YouTrackErrorInfo getErrorInfo() {
            YouTrackErrorInfo youTrackErrorInfo = this.myErrorInfo;
            if (youTrackErrorInfo == null) {
                YouTrackRequestFailedException.$$$reportNull$$$0(2);
            }
            return youTrackErrorInfo;
        }

        @NotNull
        @NlsSafe
        private static String mostDescriptiveMessage(@NotNull YouTrackErrorInfo errorInfo) {
            if (errorInfo == null) {
                YouTrackRequestFailedException.$$$reportNull$$$0(3);
            }
            return StringUtil.isNotEmpty((String)errorInfo.getErrorDescription()) ? errorInfo.getErrorDescription() : (StringUtil.isNotEmpty((String)errorInfo.getError()) ? errorInfo.getError() : "Unknown error");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackRepository$YouTrackRequestFailedException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackRepository$YouTrackRequestFailedException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "mostDescriptiveMessage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

