/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.restructuredtext.RestLanguage;
import com.intellij.restructuredtext.RestTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public RestEditorHighlighter(@NotNull EditorColorsScheme scheme, @Nullable Project project, @Nullable VirtualFile file) {
        SyntaxHighlighter jsSyntaxHighlighterFactory;
        SyntaxHighlighter djangoSyntaxHighlighterFactory;
        FileType djangoTemplateFileType;
        SyntaxHighlighter pythonSyntaxHighlighterFactory;
        if (scheme == null) {
            RestEditorHighlighter.$$$reportNull$$$0(0);
        }
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RestLanguage.INSTANCE, (Project)project, (VirtualFile)file), scheme);
        if (project == null || file == null) {
            return;
        }
        FileType pythonFileType = FileTypeManager.getInstance().findFileTypeByName("Python");
        if (pythonFileType != null && (pythonSyntaxHighlighterFactory = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)pythonFileType, (Project)project, (VirtualFile)file)) != null) {
            this.registerLayer(RestTokenTypes.PYTHON_LINE, new LayerDescriptor(pythonSyntaxHighlighterFactory, "", EditorColors.INJECTED_LANGUAGE_FRAGMENT));
        }
        if ((djangoTemplateFileType = FileTypeManager.getInstance().findFileTypeByName("DjangoTemplate")) != null && (djangoSyntaxHighlighterFactory = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)djangoTemplateFileType, (Project)project, (VirtualFile)file)) != null) {
            this.registerLayer(RestTokenTypes.DJANGO_LINE, new LayerDescriptor(djangoSyntaxHighlighterFactory, "", EditorColors.INJECTED_LANGUAGE_FRAGMENT));
        }
        if ((jsSyntaxHighlighterFactory = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JS, (Project)project, (VirtualFile)file)) != null) {
            this.registerLayer(RestTokenTypes.JAVASCRIPT_LINE, new LayerDescriptor(jsSyntaxHighlighterFactory, "", EditorColors.INJECTED_LANGUAGE_FRAGMENT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/restructuredtext/RestEditorHighlighter", "<init>"));
    }
}

