/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.input.internal.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0015\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0018\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\u0019"}, d2={"isSurrogatePair", "", "high", "", "low", "backspace", "", "Landroidx/compose/foundation/text/input/internal/EditingBuffer;", "commitText", "text", "", "newCursorPosition", "", "deleteAll", "deleteSurroundingText", "lengthBeforeCursor", "lengthAfterCursor", "deleteSurroundingTextInCodePoints", "finishComposingText", "moveCursor", "amount", "setComposingRegion", "start", "end", "setComposingText", "foundation"})
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n+ 2 MathUtils.kt\nandroidx/compose/foundation/text/input/internal/MathUtilsKt\n*L\n1#1,304:1\n27#2,3:305\n36#2,4:308\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n*L\n156#1:305,3\n161#1:308,4\n*E\n"})
public final class EditCommandKt {
    public static final void commitText(@NotNull EditingBuffer $this$commitText, @NotNull String text, int newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$commitText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if ($this$commitText.hasComposition()) {
            $this$commitText.replace($this$commitText.getCompositionStart(), $this$commitText.getCompositionEnd(), text);
        } else {
            $this$commitText.replace($this$commitText.getSelectionStart(), $this$commitText.getSelectionEnd(), text);
        }
        int newCursor = $this$commitText.getCursor();
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : newCursor + newCursorPosition - text.length();
        $this$commitText.setCursor(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$commitText.getLength()));
    }

    public static final void setComposingRegion(@NotNull EditingBuffer $this$setComposingRegion, int start, int end2) {
        int clampedEnd;
        int clampedStart;
        Intrinsics.checkNotNullParameter((Object)$this$setComposingRegion, (String)"<this>");
        if ($this$setComposingRegion.hasComposition()) {
            $this$setComposingRegion.commitComposition();
        }
        if ((clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)$this$setComposingRegion.getLength())) != (clampedEnd = RangesKt.coerceIn((int)end2, (int)0, (int)$this$setComposingRegion.getLength()))) {
            if (clampedStart < clampedEnd) {
                $this$setComposingRegion.setComposition(clampedStart, clampedEnd);
            } else {
                $this$setComposingRegion.setComposition(clampedEnd, clampedStart);
            }
        }
    }

    public static final void setComposingText(@NotNull EditingBuffer $this$setComposingText, @NotNull String text, int newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$setComposingText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if ($this$setComposingText.hasComposition()) {
            int compositionStart = $this$setComposingText.getCompositionStart();
            $this$setComposingText.replace(compositionStart, $this$setComposingText.getCompositionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                $this$setComposingText.setComposition(compositionStart, compositionStart + text.length());
            }
        } else {
            int selectionStart = $this$setComposingText.getSelectionStart();
            $this$setComposingText.replace(selectionStart, $this$setComposingText.getSelectionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                $this$setComposingText.setComposition(selectionStart, selectionStart + text.length());
            }
        }
        int newCursor = $this$setComposingText.getCursor();
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : newCursor + newCursorPosition - text.length();
        $this$setComposingText.setCursor(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$setComposingText.getLength()));
    }

    public static final void deleteSurroundingText(@NotNull EditingBuffer $this$deleteSurroundingText, int lengthBeforeCursor, int lengthAfterCursor) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$deleteSurroundingText, (String)"<this>");
        if (!(lengthBeforeCursor >= 0 && lengthAfterCursor >= 0)) {
            boolean $i$a$-require-EditCommandKt$deleteSurroundingText$22 = false;
            String $i$a$-require-EditCommandKt$deleteSurroundingText$22 = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException($i$a$-require-EditCommandKt$deleteSurroundingText$22.toString());
        }
        int $this$addExactOrElse$iv = $this$deleteSurroundingText.getSelectionEnd();
        boolean $i$f$addExactOrElse = false;
        int result$iv = $this$addExactOrElse$iv + lengthAfterCursor;
        if ((($this$addExactOrElse$iv ^ result$iv) & (lengthAfterCursor ^ result$iv)) < 0) {
            boolean bl = false;
            n2 = $this$deleteSurroundingText.getLength();
        } else {
            n2 = result$iv;
        }
        int end2 = n2;
        $this$deleteSurroundingText.delete($this$deleteSurroundingText.getSelectionEnd(), Math.min(end2, $this$deleteSurroundingText.getLength()));
        int $this$subtractExactOrElse$iv = $this$deleteSurroundingText.getSelectionStart();
        boolean $i$f$subtractExactOrElse = false;
        int result$iv2 = $this$subtractExactOrElse$iv - lengthBeforeCursor;
        if ((($this$subtractExactOrElse$iv ^ lengthBeforeCursor) & ($this$subtractExactOrElse$iv ^ result$iv2)) < 0) {
            boolean bl = false;
            n = 0;
        } else {
            n = result$iv2;
        }
        int start = n;
        $this$deleteSurroundingText.delete(Math.max(0, start), $this$deleteSurroundingText.getSelectionStart());
    }

    public static final void deleteSurroundingTextInCodePoints(@NotNull EditingBuffer $this$deleteSurroundingTextInCodePoints, int lengthBeforeCursor, int lengthAfterCursor) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteSurroundingTextInCodePoints, (String)"<this>");
        if (!(lengthBeforeCursor >= 0 && lengthAfterCursor >= 0)) {
            boolean $i$a$-require-EditCommandKt$deleteSurroundingTextInCodePoints$22 = false;
            String $i$a$-require-EditCommandKt$deleteSurroundingTextInCodePoints$22 = "Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.";
            throw new IllegalArgumentException($i$a$-require-EditCommandKt$deleteSurroundingTextInCodePoints$22.toString());
        }
        int beforeLenInChars = 0;
        for (int i = 0; i < lengthBeforeCursor; ++i) {
            if ($this$deleteSurroundingTextInCodePoints.getSelectionStart() > ++beforeLenInChars) {
                char trail;
                char lead = $this$deleteSurroundingTextInCodePoints.get($this$deleteSurroundingTextInCodePoints.getSelectionStart() - beforeLenInChars - 1);
                if (!EditCommandKt.isSurrogatePair(lead, trail = $this$deleteSurroundingTextInCodePoints.get($this$deleteSurroundingTextInCodePoints.getSelectionStart() - beforeLenInChars))) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = $this$deleteSurroundingTextInCodePoints.getSelectionStart();
            break;
        }
        int afterLenInChars = 0;
        for (int i = 0; i < lengthAfterCursor; ++i) {
            if ($this$deleteSurroundingTextInCodePoints.getSelectionEnd() + ++afterLenInChars < $this$deleteSurroundingTextInCodePoints.getLength()) {
                char trail;
                char lead = $this$deleteSurroundingTextInCodePoints.get($this$deleteSurroundingTextInCodePoints.getSelectionEnd() + afterLenInChars - 1);
                if (!EditCommandKt.isSurrogatePair(lead, trail = $this$deleteSurroundingTextInCodePoints.get($this$deleteSurroundingTextInCodePoints.getSelectionEnd() + afterLenInChars))) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = $this$deleteSurroundingTextInCodePoints.getLength() - $this$deleteSurroundingTextInCodePoints.getSelectionEnd();
            break;
        }
        $this$deleteSurroundingTextInCodePoints.delete($this$deleteSurroundingTextInCodePoints.getSelectionEnd(), $this$deleteSurroundingTextInCodePoints.getSelectionEnd() + afterLenInChars);
        $this$deleteSurroundingTextInCodePoints.delete($this$deleteSurroundingTextInCodePoints.getSelectionStart() - beforeLenInChars, $this$deleteSurroundingTextInCodePoints.getSelectionStart());
    }

    public static final void finishComposingText(@NotNull EditingBuffer $this$finishComposingText) {
        Intrinsics.checkNotNullParameter((Object)$this$finishComposingText, (String)"<this>");
        $this$finishComposingText.commitComposition();
    }

    public static final void backspace(@NotNull EditingBuffer $this$backspace) {
        Intrinsics.checkNotNullParameter((Object)$this$backspace, (String)"<this>");
        if ($this$backspace.hasComposition()) {
            $this$backspace.delete($this$backspace.getCompositionStart(), $this$backspace.getCompositionEnd());
        } else if ($this$backspace.getCursor() == -1) {
            int delStart = $this$backspace.getSelectionStart();
            int delEnd = $this$backspace.getSelectionEnd();
            $this$backspace.setCursor($this$backspace.getSelectionStart());
            $this$backspace.delete(delStart, delEnd);
        } else if ($this$backspace.getCursor() != 0) {
            int prevCursorPos = StringHelpers_skikoKt.findPrecedingBreak($this$backspace.toString(), $this$backspace.getCursor());
            $this$backspace.delete(prevCursorPos, $this$backspace.getCursor());
        }
    }

    public static final void moveCursor(@NotNull EditingBuffer $this$moveCursor, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCursor, (String)"<this>");
        if ($this$moveCursor.getCursor() == -1) {
            $this$moveCursor.setCursor($this$moveCursor.getSelectionStart());
        }
        int newCursor = $this$moveCursor.getSelectionStart();
        String bufferText = $this$moveCursor.toString();
        if (amount > 0) {
            int next2;
            for (int i = 0; i < amount && (next2 = StringHelpers_skikoKt.findFollowingBreak(bufferText, newCursor)) != -1; ++i) {
                newCursor = next2;
            }
        } else {
            int prev;
            int n = -amount;
            for (int i = 0; i < n && (prev = StringHelpers_skikoKt.findPrecedingBreak(bufferText, newCursor)) != -1; ++i) {
                newCursor = prev;
            }
        }
        $this$moveCursor.setCursor(newCursor);
    }

    public static final void deleteAll(@NotNull EditingBuffer $this$deleteAll) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteAll, (String)"<this>");
        $this$deleteAll.replace(0, $this$deleteAll.getLength(), "");
    }

    private static final boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }
}

