/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.tensorFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.impl.PyImportResolver;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.tensorFlow.PyTensorFlowKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/tensorFlow/PyTensorFlowImportResolver;", "Lcom/jetbrains/python/psi/impl/PyImportResolver;", "<init>", "()V", "resolveImportReference", "Lcom/intellij/psi/PsiElement;", "name", "Lcom/intellij/psi/util/QualifiedName;", "context", "Lcom/jetbrains/python/psi/resolve/PyQualifiedNameResolveContext;", "withRoots", "", "isTensorFlowMember", "pathConfig", "", "", "intellij.python.psi.impl"})
@ApiStatus.Internal
public final class PyTensorFlowImportResolver
implements PyImportResolver {
    @Override
    @Nullable
    public PsiElement resolveImportReference(@NotNull QualifiedName name2, @NotNull PyQualifiedNameResolveContext context, boolean withRoots) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isTensorFlowMember(name2)) {
            PyQualifiedNameResolveContext pyQualifiedNameResolveContext = context.copyWithoutForeign();
            Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"copyWithoutForeign(...)");
            PyQualifiedNameResolveContext resolveContext = pyQualifiedNameResolveContext;
            psiElement = this.resolveImportReference(name2, resolveContext, PyTensorFlowKt.getTensorFlowPathConfig(resolveContext.getSdk()));
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    private final boolean isTensorFlowMember(QualifiedName name2) {
        return Intrinsics.areEqual((Object)name2.getFirstComponent(), (Object)"tensorflow") && name2.getComponentCount() > 1;
    }

    private final PsiElement resolveImportReference(QualifiedName name2, PyQualifiedNameResolveContext context, Map<String, String> pathConfig) {
        String path2 = pathConfig.get(name2.getComponents().get(1));
        if (path2 != null) {
            return PyTensorFlowKt.takeFirstResolvedInTensorFlow(path2 + "." + name2.removeHead(2), context);
        }
        return PyTensorFlowKt.takeFirstResolvedInTensorFlow(pathConfig.get("*") + "." + name2.removeHead(1), context);
    }
}

