/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.extensions.FileChooserDescriptorExtKt;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyBrowseActionListener;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationPanel;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfigurationForm
implements PythonRunConfigurationParams,
PanelWithAnchor {
    private final PythonRunConfigurationPanel content;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;
    private final Project myProject;
    private boolean myModuleMode;

    public PythonRunConfigurationForm(PythonRunConfiguration configuration) {
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsForm.addInterpreterModeListener(isRemoteInterpreter -> this.emulateTerminalEnabled(isRemoteInterpreter == false));
        this.content = new PythonRunConfigurationPanel(configuration, this.myCommonOptionsForm, new MyComboBox());
        this.myProject = configuration.getProject();
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorExtKt.withPythonFiles(FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(PyBundle.message("python.run.select.script", new Object[0])), true);
        PyBrowseActionListener listener2 = new PyBrowseActionListener(configuration, chooserDescriptor){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                PythonRunConfigurationForm.this.myCommonOptionsForm.setWorkingDirectory(chosenFile.getParent().getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/python/run/PythonRunConfigurationForm$1", "onFileChosen"));
            }
        };
        this.content.scriptTextField.addBrowseFolderListener((TextBrowseFolderListener)listener2);
        if (SystemInfo.isWindows) {
            this.emulateTerminalEnabled(false);
        }
        this.content.emulateTerminalCheckbox.setSelected(false);
        this.content.inputFileTextFieldWithBrowseButton.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor(), this.myProject));
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)this.content.scriptParametersTextField.getEditorField());
    }

    private void updateRunModuleMode() {
        boolean mode = (PythonRunConfigurationForm.getModuleNameText() + ":").equals(this.content.targetComboBox.getText());
        this.setModuleModeInternal(mode);
    }

    private void emulateTerminalEnabled(boolean flag) {
        this.content.emulateTerminalCheckbox.setVisible(flag);
    }

    public JComponent getPanel() {
        return this.content.panel;
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this.myCommonOptionsForm;
    }

    @Override
    public String getScriptName() {
        if (this.isModuleMode()) {
            return this.content.moduleField.getText().trim();
        }
        return FileUtil.toSystemIndependentName((String)this.content.scriptTextField.getText().trim());
    }

    @Override
    public void setScriptName(String scriptName) {
        if (this.isModuleMode()) {
            this.content.moduleField.setText(StringUtil.notNullize((String)scriptName));
        } else {
            this.content.scriptTextField.setText(scriptName == null ? "" : FileUtil.toSystemDependentName((String)scriptName));
        }
    }

    @Override
    public String getScriptParameters() {
        return this.content.scriptParametersTextField.getText().trim();
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.content.scriptParametersTextField.setText(scriptParameters);
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.content.showCommandLineCheckbox.isSelected();
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.content.showCommandLineCheckbox.setSelected(showCommandLineAfterwards);
    }

    @Override
    public boolean emulateTerminal() {
        return this.content.emulateTerminalCheckbox.isSelected();
    }

    @Override
    public void setEmulateTerminal(boolean emulateTerminal) {
        this.content.emulateTerminalCheckbox.setSelected(emulateTerminal);
    }

    @Override
    public boolean isModuleMode() {
        return this.myModuleMode;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public boolean isMultiprocessMode() {
        return PyDebuggerOptionsProvider.getInstance(this.myProject).isAttachToSubprocess();
    }

    public void setMultiprocessMode(boolean multiprocess) {
    }

    @Nls
    public static String getScriptPathText() {
        return PyBundle.message("runcfg.labels.script.path", new Object[0]);
    }

    @Nls
    public static String getModuleNameText() {
        return PyBundle.message("runcfg.labels.module.name", new Object[0]);
    }

    @Nls
    public static String getCustomNameText() {
        return PyBundle.message("runcfg.labels.custom.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getInputFile() {
        String string = this.content.inputFileTextFieldWithBrowseButton.getText();
        if (string == null) {
            PythonRunConfigurationForm.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void setInputFile(@NotNull String inputFile) {
        if (inputFile == null) {
            PythonRunConfigurationForm.$$$reportNull$$$0(1);
        }
        this.content.inputFileTextFieldWithBrowseButton.setText(inputFile);
    }

    @Override
    public boolean isRedirectInput() {
        return this.content.redirectInputCheckBox.isSelected();
    }

    @Override
    public void setRedirectInput(boolean isRedirectInput) {
        this.content.redirectInputCheckBox.setSelected(isRedirectInput);
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myCommonOptionsForm.setAnchor(anchor);
    }

    @Override
    public void setModuleMode(boolean moduleMode) {
        this.setTargetComboBoxValue(moduleMode ? PythonRunConfigurationForm.getModuleNameText() : PythonRunConfigurationForm.getScriptPathText());
        this.setModuleModeInternal(moduleMode);
    }

    private void setModuleModeInternal(boolean moduleMode) {
        this.myModuleMode = moduleMode;
        this.content.setModuleMode(moduleMode);
    }

    private void setTargetComboBoxValue(@NlsContexts.Label String text) {
        this.content.targetComboBox.setText(text + ":");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunConfigurationForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInputFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class MyComboBox
    extends JBComboBoxLabel
    implements UserActivityProviderComponent {
        private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        MyComboBox() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(PyBundle.message("python.configuration.choose.target.to.run", new Object[0]), (List)Lists.newArrayList((Object[])new String[]{PythonRunConfigurationForm.getScriptPathText(), PythonRunConfigurationForm.getModuleNameText()})){

                        public PopupStep<?> onChosen(@Nls String selectedValue, boolean finalChoice) {
                            PythonRunConfigurationForm.this.setTargetComboBoxValue(selectedValue);
                            PythonRunConfigurationForm.this.updateRunModuleMode();
                            return FINAL_CHOICE;
                        }
                    }).showUnderneathOf((Component)((Object)MyComboBox.this));
                }
            });
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyComboBox.$$$reportNull$$$0(0);
            }
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyComboBox.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(changeListener);
        }

        void fireChangeEvent() {
            for (ChangeListener l : this.myListeners) {
                l.stateChanged(new ChangeEvent((Object)this));
            }
        }

        public void setText(String text) {
            super.setText(text);
            this.fireChangeEvent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationForm$MyComboBox";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

