/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyVariadicType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyUnpackedTupleTypeImpl
implements PyUnpackedTupleType {
    public static final PyUnpackedTupleType UNSPECIFIED = new PyUnpackedTupleTypeImpl(Collections.singletonList(null), true);
    private final List<PyType> myElementTypes;
    private final boolean myIsHomogeneous;

    public PyUnpackedTupleTypeImpl(@NotNull List<? extends PyType> elementTypes, boolean isUnbound) {
        if (elementTypes == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (isUnbound) {
            if (elementTypes.size() != 1) {
                throw new IllegalArgumentException("Unbounded unpacked tuple type can have only one type parameter");
            }
            if (elementTypes.get(0) instanceof PyVariadicType) {
                throw new IllegalArgumentException("Unbounded unpacked tuple type of a TypeVarTuple or another unpacked tuple type is now allowed");
            }
        }
        this.myElementTypes = new ArrayList<PyType>(elementTypes);
        this.myIsHomogeneous = isUnbound;
    }

    @NotNull
    public static PyUnpackedTupleType create(@NotNull List<? extends PyType> elementTypes) {
        if (elementTypes == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(1);
        }
        return new PyUnpackedTupleTypeImpl(elementTypes, false);
    }

    @NotNull
    public static PyUnpackedTupleType createUnbound(@Nullable PyType type2) {
        return new PyUnpackedTupleTypeImpl(Collections.singletonList(type2), true);
    }

    @Override
    @NotNull
    public String getName() {
        StringBuilder res = new StringBuilder("*tuple[");
        StringUtil.join(this.myElementTypes, type2 -> type2 != null ? type2.getName() : "Any", (String)", ", (StringBuilder)res);
        if (this.isUnbound()) {
            res.append(", ...");
        }
        res.append("]");
        String string = res.toString();
        if (string == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PyType> getElementTypes() {
        List<PyType> list = Collections.unmodifiableList(this.myElementTypes);
        if (list == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public boolean isUnbound() {
        return this.myIsHomogeneous;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyUnpackedTupleTypeImpl type2 = (PyUnpackedTupleTypeImpl)o;
        return this.myIsHomogeneous == type2.myIsHomogeneous && Objects.equals(this.myElementTypes, type2.myElementTypes);
    }

    public int hashCode() {
        return Objects.hash(this.myElementTypes, this.myIsHomogeneous);
    }

    public String toString() {
        return "PyUnpackedTupleType: " + this.getName();
    }

    @Nullable
    public PyTupleType asTupleType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(4);
        }
        if (this.isUnbound()) {
            return PyTupleType.createHomogeneous(anchor, this.getElementTypes().get(0));
        }
        return PyTupleType.create(anchor, this.getElementTypes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyUnpackedTupleTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyUnpackedTupleTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asTupleType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

