/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.debugger.containerview.TextFieldCommandSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 l2\u00020\u00012\u00020\u0002:\u0003jklB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\u001dH\u0002J\b\u0010K\u001a\u00020IH\u0002J\b\u0010L\u001a\u00020IH\u0002J\u0010\u0010M\u001a\u00020I2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010N\u001a\u00020\u000fH\u0014J\u0010\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020I2\u0006\u0010P\u001a\u00020QH\u0004J$\u0010S\u001a\u00020I2\b\u0010T\u001a\u0004\u0018\u00010\"2\u0006\u0010U\u001a\u00020\u001d2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010QJ$\u0010S\u001a\u00020I2\u0006\u0010+\u001a\u00020,2\u0006\u0010U\u001a\u00020\u001d2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0018\u0010V\u001a\u00020I2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010W\u001a\u00020XH\u0014J\"\u0010Y\u001a\u00020I2\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020,2\u0006\u0010U\u001a\u00020\u001dH\u0014J(\u0010]\u001a\u00020I2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020,2\u0006\u0010W\u001a\u00020X2\u0006\u0010U\u001a\u00020\u001dH\u0014J)\u0010-\u001a\u0004\u0018\u00010,2\r\u0010^\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#2\u0006\u0010_\u001a\u00020\u001d2\u0006\u0010U\u001a\u00020\u001dH\u0002J\u000e\u0010`\u001a\u00020I2\u0006\u0010a\u001a\u00020\u001dJ\u001d\u0010b\u001a\u00020I2\u000b\u0010c\u001a\u00070\"\u00a2\u0006\u0002\bd2\u0006\u0010U\u001a\u00020\u001dH\u0016J\"\u0010e\u001a\u00070\"\u00a2\u0006\u0002\bf2\u000b\u0010c\u001a\u00070\"\u00a2\u0006\u0002\bd2\u0006\u0010U\u001a\u00020\u001dH\u0004J\u000e\u0010g\u001a\u00020I2\u0006\u0010h\u001a\u00020 J\b\u0010i\u001a\u00020IH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010$\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#2\r\u0010!\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010&\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R&\u00101\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"8V@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010&\"\u0004\b3\u0010*R&\u00104\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"8V@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010&\"\u0004\b6\u0010*R$\u00108\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0016\u0010<\u001a\u0004\u0018\u00010=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R$\u0010@\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00109\"\u0004\bA\u0010;R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020FX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010G\u00a8\u0006m"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "getFrameAccessor", "()Lcom/jetbrains/python/debugger/PyFrameAccessor;", "tablePanel", "getTablePanel", "()Ljavax/swing/JPanel;", "table", "Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "getTable", "()Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "setTable", "(Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;)V", "sliceTextFieldOldTable", "Lcom/intellij/ui/EditorTextField;", "getSliceTextFieldOldTable", "()Lcom/intellij/ui/EditorTextField;", "formatTextFieldOldTable", "getFormatTextFieldOldTable", "setFormatTextFieldOldTable", "(Lcom/intellij/ui/EditorTextField;)V", "colored", "", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Listener;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "originalVarName", "getOriginalVarName", "()Ljava/lang/String;", "modifiedVarName", "getModifiedVarName", "setModifiedVarName", "(Ljava/lang/String;)V", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getDebugValue", "()Lcom/jetbrains/python/debugger/PyDebugValue;", "setDebugValue", "(Lcom/jetbrains/python/debugger/PyDebugValue;)V", "format", "getFormat", "setFormat", "slicing", "getSlicing", "setSlicing", "state", "isColored", "()Z", "setColored", "(Z)V", "model", "Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "getModel", "()Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "isModified", "setModified", "errorLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JEditorPane;", "isSlicingAndFormattingOldPanelsVisible", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "()Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "dispose", "", "isVariablePresentInStack", "setupChangeListener", "updateModel", "updateDebugValue", "getOrCreateMainTable", "createEditorField", "commandSource", "Lcom/jetbrains/python/debugger/containerview/TextFieldCommandSource;", "onEnterPressed", "apply", "name", "modifier", "doStrategyInitExecution", "strategy", "Lcom/jetbrains/python/debugger/containerview/DataViewStrategy;", "updateTabNameAndSliceField", "chunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "originalDebugValue", "updateUI", "expression", "pooledThread", "resize", "autoResize", "setError", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "composeErrorMessage", "Lorg/jetbrains/annotations/Nls;", "addListener", "listener", "closeEditorTabs", "Listener", "PyDataViewCompletionProvider", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataViewerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public class PyDataViewerPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project project;
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private final JPanel tablePanel;
    @Nullable
    private AbstractDataViewTable table;
    @NotNull
    private final EditorTextField sliceTextFieldOldTable;
    @NotNull
    private EditorTextField formatTextFieldOldTable;
    private boolean colored;
    @NotNull
    private final CopyOnWriteArrayList<Listener> listeners;
    @Nullable
    private String originalVarName;
    @Nullable
    private String modifiedVarName;
    @Nullable
    private PyDebugValue debugValue;
    @NotNull
    private String format;
    @NotNull
    private String slicing;
    private boolean isModified;
    private Cell<? extends JEditorPane> errorLabel;
    @NotNull
    private final AtomicBooleanProperty isSlicingAndFormattingOldPanelsVisible;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MODIFIED_VARIABLE_FORMAT = "%s*";

    public PyDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        super(new BorderLayout());
        this.project = project;
        this.frameAccessor = frameAccessor;
        this.tablePanel = new JPanel(new BorderLayout());
        this.sliceTextFieldOldTable = this.createEditorField(TextFieldCommandSource.SLICING);
        this.formatTextFieldOldTable = this.createEditorField(TextFieldCommandSource.FORMATTING);
        this.colored = PyDataView.Companion.isColoringEnabled(this.project);
        this.listeners = new CopyOnWriteArrayList();
        this.format = "";
        this.slicing = "";
        this.isSlicingAndFormattingOldPanelsVisible = new AtomicBooleanProperty(true);
        new PyDataViewCompletionProvider().apply(this.sliceTextFieldOldTable);
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> PyDataViewerPanel._init_$lambda$6(this, arg_0));
        this.add((Component)panel2, "Center");
        this.setupChangeListener();
    }

    @NotNull
    public final PyFrameAccessor getFrameAccessor() {
        return this.frameAccessor;
    }

    @NotNull
    protected final JPanel getTablePanel() {
        return this.tablePanel;
    }

    @Nullable
    protected final AbstractDataViewTable getTable() {
        return this.table;
    }

    protected final void setTable(@Nullable AbstractDataViewTable abstractDataViewTable) {
        this.table = abstractDataViewTable;
    }

    @NotNull
    protected final EditorTextField getSliceTextFieldOldTable() {
        return this.sliceTextFieldOldTable;
    }

    @NotNull
    protected final EditorTextField getFormatTextFieldOldTable() {
        return this.formatTextFieldOldTable;
    }

    protected final void setFormatTextFieldOldTable(@NotNull EditorTextField editorTextField) {
        Intrinsics.checkNotNullParameter((Object)editorTextField, (String)"<set-?>");
        this.formatTextFieldOldTable = editorTextField;
    }

    @Nullable
    public final String getOriginalVarName() {
        return this.originalVarName;
    }

    @Nullable
    protected final String getModifiedVarName() {
        return this.modifiedVarName;
    }

    protected final void setModifiedVarName(@Nullable String string) {
        this.modifiedVarName = string;
    }

    @Nullable
    protected final PyDebugValue getDebugValue() {
        return this.debugValue;
    }

    protected final void setDebugValue(@Nullable PyDebugValue pyDebugValue) {
        this.debugValue = pyDebugValue;
    }

    @NotNull
    public String getFormat() {
        CharSequence charSequence;
        String string = this.formatTextFieldOldTable.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String format = string;
        CharSequence charSequence2 = format;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "%s";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    protected void setFormat(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.format = value;
        this.formatTextFieldOldTable.setText(value);
    }

    @NotNull
    public String getSlicing() {
        CharSequence charSequence;
        String string = this.sliceTextFieldOldTable.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String slicing = string;
        CharSequence charSequence2 = slicing;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "None";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    protected void setSlicing(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.slicing = value;
        this.sliceTextFieldOldTable.setText(value);
    }

    public final boolean isColored() {
        return this.colored;
    }

    public final void setColored(boolean state) {
        this.colored = state;
        AbstractDataViewTable table = this.table;
        if (table != null && !table.isEmpty()) {
            TableCellRenderer tableCellRenderer = table.getDefaultRenderer(table.getColumnClass(0));
            Intrinsics.checkNotNull((Object)tableCellRenderer, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.ColoredCellRenderer");
            ((ColoredCellRenderer)tableCellRenderer).setColored(state);
            table.repaint();
        }
    }

    private final AsyncArrayTableModel getModel() {
        AbstractDataViewTable abstractDataViewTable = this.table;
        TableModel tableModel = abstractDataViewTable != null ? abstractDataViewTable.getModel() : null;
        return tableModel instanceof AsyncArrayTableModel ? (AsyncArrayTableModel)tableModel : null;
    }

    public final boolean isModified() {
        return this.isModified;
    }

    protected final void setModified(boolean bl) {
        this.isModified = bl;
    }

    @NotNull
    protected final AtomicBooleanProperty isSlicingAndFormattingOldPanelsVisible() {
        return this.isSlicingAndFormattingOldPanelsVisible;
    }

    public void dispose() {
    }

    private final boolean isVariablePresentInStack() {
        XValueChildrenList xValueChildrenList = this.frameAccessor.loadFrame(null);
        if (xValueChildrenList == null) {
            return true;
        }
        XValueChildrenList values = xValueChildrenList;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)values.getValue(i), (Object)((Object)this.debugValue))) continue;
            return true;
        }
        return false;
    }

    private final void setupChangeListener() {
        this.frameAccessor.addFrameListener(new PyFrameListener(this){
            final /* synthetic */ PyDataViewerPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void frameChanged() {
                if (this.this$0.getDebugValue() == null) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> setupChangeListener.1.frameChanged$lambda$0(this.this$0));
            }

            private static final void frameChanged$lambda$0(PyDataViewerPanel this$0) {
                if (PyDataViewerPanel.access$isVariablePresentInStack(this$0)) {
                    PyDataViewerPanel.access$updateModel(this$0);
                }
            }
        });
    }

    private final void updateModel() {
        AsyncArrayTableModel asyncArrayTableModel = this.getModel();
        if (asyncArrayTableModel == null) {
            return;
        }
        AsyncArrayTableModel model2 = asyncArrayTableModel;
        model2.invalidateCache();
        if (this.isModified) {
            PyDataViewerPanel.apply$default(this, this.modifiedVarName, true, null, 4, null);
        } else {
            this.updateDebugValue(model2);
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.updateModel$lambda$7(this, model2));
        }
    }

    private final void updateDebugValue(AsyncArrayTableModel model2) {
        PyDebugValue oldValue = model2.getDebugValue();
        if (oldValue != null && !oldValue.isTemporary() || ((CharSequence)this.getSlicing()).length() == 0) {
            return;
        }
        PyDebugValue newValue = this.getDebugValue(this.getSlicing(), false, false);
        if (newValue != null) {
            model2.setDebugValue(newValue);
        }
    }

    @NotNull
    protected AbstractDataViewTable getOrCreateMainTable() {
        JBTableWithRowHeaders mainTable = new JBTableWithRowHeaders(PyDataView.Companion.isAutoResizeEnabled(this.project));
        mainTable.getScrollPane().setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel.add((Component)mainTable.getScrollPane(), "Center");
        this.table = mainTable;
        return mainTable;
    }

    private final EditorTextField createEditorField(TextFieldCommandSource commandSource) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Project project = this.project;
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        return new EditorTextField(this, commandSource, document, project, pythonFileType){
            final /* synthetic */ PyDataViewerPanel this$0;
            final /* synthetic */ TextFieldCommandSource $commandSource;
            {
                this.this$0 = $receiver;
                this.$commandSource = $commandSource;
                super($super_call_param$1, $super_call_param$2, (FileType)$super_call_param$3, false, true);
            }

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor2 = editorEx;
                editor2.getSettings().setAdditionalColumnsCount(5);
                editor2.getContentComponent().addKeyListener(new KeyAdapter(this.this$0, this.$commandSource){
                    final /* synthetic */ PyDataViewerPanel this$0;
                    final /* synthetic */ TextFieldCommandSource $commandSource;
                    {
                        this.this$0 = $receiver;
                        this.$commandSource = $commandSource;
                    }

                    public void keyPressed(KeyEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.getKeyCode() == 10) {
                            this.this$0.onEnterPressed(this.$commandSource);
                        }
                    }
                });
                return editor2;
            }
        };
    }

    protected final void onEnterPressed(@NotNull TextFieldCommandSource commandSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandSource), (String)"commandSource");
        this.apply(this.getSlicing(), false, commandSource);
    }

    public final void apply(@Nullable String name2, boolean modifier, @Nullable TextFieldCommandSource commandSource) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerPanel.apply$lambda$10(this, name2, modifier, commandSource));
    }

    public static /* synthetic */ void apply$default(PyDataViewerPanel pyDataViewerPanel, String string, boolean bl, TextFieldCommandSource textFieldCommandSource, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            textFieldCommandSource = null;
        }
        pyDataViewerPanel.apply(string, bl, textFieldCommandSource);
    }

    public void apply(@NotNull PyDebugValue debugValue, boolean modifier, @Nullable TextFieldCommandSource commandSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugValue), (String)"debugValue");
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(false);
        String type2 = debugValue.getType();
        DataViewStrategy strategy = DataViewStrategy.getStrategy(type2);
        if (strategy == null) {
            Object[] objectArray = new Object[]{type2};
            String string = PyBundle.message("debugger.data.view.type.is.not.supported", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.setError(string, modifier);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerPanel.apply$lambda$14(this, debugValue, strategy, type2, modifier));
    }

    public static /* synthetic */ void apply$default(PyDataViewerPanel pyDataViewerPanel, PyDebugValue pyDebugValue, boolean bl, TextFieldCommandSource textFieldCommandSource, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            textFieldCommandSource = null;
        }
        pyDataViewerPanel.apply(pyDebugValue, bl, textFieldCommandSource);
    }

    protected void doStrategyInitExecution(@NotNull PyFrameAccessor frameAccessor, @NotNull DataViewStrategy strategy) throws PyDebuggerException {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
    }

    protected void updateTabNameAndSliceField(@Nullable ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, boolean modifier) {
        Object object;
        String realName;
        Intrinsics.checkNotNullParameter((Object)((Object)originalDebugValue), (String)"originalDebugValue");
        ArrayChunk arrayChunk = chunk;
        PyDebugValue debugValue = arrayChunk != null ? arrayChunk.getValue() : null;
        String shownName = realName = debugValue == null || Intrinsics.areEqual((Object)debugValue.getName(), (Object)originalDebugValue.getTempName()) ? originalDebugValue.getName() : chunk.getSlicePresentation();
        if (modifier && !Intrinsics.areEqual((Object)this.originalVarName, (Object)shownName)) {
            String string = MODIFIED_VARIABLE_FORMAT;
            object = new Object[]{this.originalVarName};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            shownName = string2;
        } else {
            this.originalVarName = realName;
        }
        String string = this.originalVarName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.setSlicing(it);
        }
        this.modifiedVarName = realName;
        if (this.sliceTextFieldOldTable.getEditor() != null) {
            CaretModel caretModel = this.sliceTextFieldOldTable.getCaretModel();
            String string3 = this.originalVarName;
            Intrinsics.checkNotNull((Object)string3);
            caretModel.moveToOffset(string3.length());
        }
        Iterator<Listener> iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Listener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Listener listener2 = iterator2.next();
            object = shownName;
            Intrinsics.checkNotNull((Object)object);
            listener2.onNameChanged((String)object);
        }
        if (chunk != null) {
            this.setFormat(chunk.getFormat());
        }
    }

    protected void updateUI(@NotNull ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, @NotNull DataViewStrategy strategy, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)((Object)originalDebugValue), (String)"originalDebugValue");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        PyDebugValue debugValue = chunk.getValue();
        AsyncArrayTableModel model2 = strategy.createTableModel(chunk.getRows(), chunk.getColumns(), this, debugValue);
        model2.addToCache(chunk);
        UIUtil.invokeLaterIfNeeded(() -> PyDataViewerPanel.updateUI$lambda$16(this, model2, modifier, chunk, originalDebugValue, strategy));
    }

    private final PyDebugValue getDebugValue(String expression, boolean pooledThread, boolean modifier) {
        PyDebugValue pyDebugValue;
        try {
            PyDebugValue value = this.frameAccessor.evaluate(expression, false, true);
            if (value == null || value.isErrorOnEval()) {
                Runnable runnable = () -> PyDataViewerPanel.getDebugValue$lambda$17(this, value, expression, modifier);
                if (pooledThread) {
                    ApplicationManager.getApplication().invokeLater(runnable);
                } else {
                    runnable.run();
                }
                return null;
            }
            pyDebugValue = value;
        }
        catch (PyDebuggerException e) {
            Runnable runnable = () -> PyDataViewerPanel.getDebugValue$lambda$18(this, e, modifier);
            if (pooledThread) {
                ApplicationManager.getApplication().invokeLater(runnable);
            } else {
                runnable.run();
            }
            pyDebugValue = null;
        }
        return pyDebugValue;
    }

    public final void resize(boolean autoResize) {
        AbstractDataViewTable abstractDataViewTable = this.table;
        if (abstractDataViewTable != null) {
            abstractDataViewTable.setAutoResize(autoResize);
        }
        PyDataViewerPanel.apply$default(this, this.getSlicing(), false, null, 4, null);
    }

    public void setError(@NotNull String text, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(true);
        Cell<? extends JEditorPane> cell2 = this.errorLabel;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell2 = null;
        }
        TextFieldKt.text(cell2, (String)this.composeErrorMessage(text, modifier));
        if (!modifier) {
            AbstractDataViewTable abstractDataViewTable = this.table;
            if (abstractDataViewTable != null) {
                abstractDataViewTable.setEmpty();
            }
            Iterator<Listener> iterator = this.listeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Listener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Listener listener2 = iterator2.next();
                String string = PyBundle.message("debugger.data.view.empty.tab", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                listener2.onNameChanged(string);
            }
        }
    }

    @NotNull
    protected final String composeErrorMessage(@NotNull String text, boolean modifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (modifier) {
            Object[] objectArray = new Object[]{text};
            String string2 = PyBundle.message("debugger.dataviewer.modifier.error", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = text;
        }
        return string;
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public void closeEditorTabs() {
    }

    private static final Unit lambda$6$lambda$2(PyDataViewerPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.tablePanel).align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$lambda$3(PyDataViewerPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.sliceTextFieldOldTable).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        String string = PyBundle.message("form.data.viewer.format", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        $this$row.cell((JComponent)this$0.formatTextFieldOldTable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$6$lambda$5(PyDataViewerPanel this$0, Row $this$row) {
        void $this$lambda_u246_u24lambda_u245_u24lambda_u244;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null);
        PyDataViewerPanel pyDataViewerPanel = this$0;
        boolean bl = false;
        ((JEditorPane)$this$lambda_u246_u24lambda_u245_u24lambda_u244.getComponent()).setForeground((Color)JBColor.RED);
        pyDataViewerPanel.errorLabel = cell;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(PyDataViewerPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyDataViewerPanel.lambda$6$lambda$2(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyDataViewerPanel.lambda$6$lambda$3(this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)this$0.isSlicingAndFormattingOldPanelsVisible);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyDataViewerPanel.lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void updateModel$lambda$7(PyDataViewerPanel this$0, AsyncArrayTableModel $model) {
        if (this$0.isShowing()) {
            $model.fireTableDataChanged();
        }
    }

    private static final void apply$lambda$10$lambda$9(PyDebugValue $debugValue, PyDataViewerPanel this$0, boolean $modifier, TextFieldCommandSource $commandSource) {
        block0: {
            PyDebugValue pyDebugValue = $debugValue;
            if (pyDebugValue == null) break block0;
            PyDebugValue it = pyDebugValue;
            boolean bl = false;
            this$0.apply(it, $modifier, $commandSource);
        }
    }

    private static final void apply$lambda$10(PyDataViewerPanel this$0, String $name, boolean $modifier, TextFieldCommandSource $commandSource) {
        PyDebugValue debugValue = this$0.getDebugValue($name, true, $modifier);
        ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$10$lambda$9(debugValue, this$0, $modifier, $commandSource));
    }

    private static final void apply$lambda$14$lambda$11(PyDataViewerPanel this$0, ArrayChunk $arrayChunk, PyDebugValue $debugValue, DataViewStrategy $strategy, boolean $modifier) {
        Intrinsics.checkNotNull((Object)$arrayChunk);
        this$0.updateUI($arrayChunk, $debugValue, $strategy, $modifier);
        this$0.isModified = $modifier;
        this$0.debugValue = $debugValue;
    }

    private static final void apply$lambda$14$lambda$12(PyDataViewerPanel this$0, IllegalArgumentException $e, boolean $modifier) {
        String string = $e.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
        this$0.setError(string, $modifier);
    }

    private static final void apply$lambda$14(PyDataViewerPanel this$0, PyDebugValue $debugValue, DataViewStrategy $strategy, String $type, boolean $modifier) {
        try {
            PyFrameAccessor pyFrameAccessor = $debugValue.getFrameAccessor();
            Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"getFrameAccessor(...)");
            this$0.doStrategyInitExecution(pyFrameAccessor, $strategy);
            ArrayChunk arrayChunk = $debugValue.getFrameAccessor().getArrayItems($debugValue, 0, 0, 0, 0, this$0.getFormat());
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$14$lambda$11(this$0, arrayChunk, $debugValue, $strategy, $modifier));
        }
        catch (IllegalArgumentException e) {
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$14$lambda$12(this$0, e, $modifier));
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
        }
        catch (Exception e) {
            boolean bl;
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = StringsKt.contains$default((CharSequence)it, (CharSequence)"Numpy is not available", (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
            if (bl) {
                Object[] objectArray = new Object[]{$type};
                String string2 = PyBundle.message("debugger.data.view.numpy.is.not.available", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this$0.setError(string2, $modifier);
            }
            LOG.error((Throwable)e);
        }
    }

    private static final void updateUI$lambda$16(PyDataViewerPanel this$0, AsyncArrayTableModel $model, boolean $modifier, ArrayChunk $chunk, PyDebugValue $originalDebugValue, DataViewStrategy $strategy) {
        AbstractDataViewTable abstractDataViewTable = this$0.table;
        if (abstractDataViewTable == null) {
            abstractDataViewTable = this$0.getOrCreateMainTable();
        }
        AbstractDataViewTable table = abstractDataViewTable;
        table.setModel($model, $modifier);
        this$0.updateTabNameAndSliceField($chunk, $originalDebugValue, $modifier);
        ColoredCellRenderer cellRenderer = $strategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, $chunk);
        cellRenderer.setColored(this$0.colored);
        $model.fireTableDataChanged();
        $model.fireTableCellUpdated(0, 0);
        if (table.getColumnCount() > 0) {
            table.setDefaultRenderer(table.getColumnClass(0), cellRenderer);
        }
        table.setShowColumns($strategy.showColumnHeader());
    }

    private static final void getDebugValue$lambda$17(PyDataViewerPanel this$0, PyDebugValue $value, String $expression, boolean $modifier) {
        String string;
        if ($value != null && $value.getValue() != null) {
            String string2 = $value.getValue();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            Object[] objectArray = new Object[]{$expression};
            String string3 = PyBundle.message("debugger.data.view.failed.to.evaluate.expression", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        this$0.setError(string, $modifier);
    }

    private static final void getDebugValue$lambda$18(PyDataViewerPanel this$0, PyDebuggerException $e, boolean $modifier) {
        String string = $e.getTracebackError();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTracebackError(...)");
        this$0.setError(string, $modifier);
    }

    public static final /* synthetic */ boolean access$isVariablePresentInStack(PyDataViewerPanel $this) {
        return $this.isVariablePresentInStack();
    }

    public static final /* synthetic */ void access$updateModel(PyDataViewerPanel $this) {
        $this.updateModel();
    }

    static {
        Logger logger = Logger.getInstance(PyDataViewerPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MODIFIED_VARIABLE_FORMAT", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Listener;", "", "onNameChanged", "", "name", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "intellij.python.community.impl"})
    public static interface Listener {
        public void onNameChanged(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider;", "Lcom/intellij/util/TextFieldCompletionProvider;", "<init>", "(Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;)V", "addCompletionVariants", "", "text", "", "offset", "", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "availableValues", "", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getAvailableValues", "()Ljava/util/List;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDataViewerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,408:1\n1053#2:409\n*S KotlinDebug\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider\n*L\n373#1:409\n*E\n"})
    private final class PyDataViewCompletionProvider
    extends TextFieldCompletionProvider {
        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Iterable $this$sortedBy$iv = this.getAvailableValues();
            boolean $i$f$sortedBy = false;
            List values = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PyDebugValue obj = (PyDebugValue)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)obj.getName());
                    obj = (PyDebugValue)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)obj.getName())));
                }
            });
            int n = ((Collection)values).size();
            for (int i = 0; i < n; ++i) {
                LookupElementBuilder element;
                PyDebugValue value = (PyDebugValue)((Object)values.get(i));
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)value.getName()).withTypeText(value.getType(), true), (String)"withTypeText(...)");
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)element), (double)(-((double)i))));
            }
        }

        private final List<PyDebugValue> getAvailableValues() {
            List values = new ArrayList();
            try {
                XValueChildrenList xValueChildrenList = PyDataViewerPanel.this.getFrameAccessor().loadFrame(null);
                if (xValueChildrenList == null) {
                    return values;
                }
                XValueChildrenList list = xValueChildrenList;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    XValue xValue = list.getValue(i);
                    Intrinsics.checkNotNull((Object)xValue, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.PyDebugValue");
                    PyDebugValue value = (PyDebugValue)xValue;
                    String type2 = value.getType();
                    if (DataViewStrategy.getStrategy(type2) == null) continue;
                    values.add(value);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return values;
        }
    }
}

