/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PowerService;
import com.intellij.util.io.PowerStatus;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/util/io/WinPowerService;", "Lcom/intellij/util/io/PowerService;", "<init>", "()V", "status", "Lcom/intellij/util/io/PowerStatus;", "kernel32", "Lcom/intellij/util/io/WinPowerService$Kernel32;", "kotlin.jvm.PlatformType", "Lcom/intellij/util/io/WinPowerService$Kernel32;", "SYSTEM_POWER_STATUS", "Kernel32", "intellij.platform.ide.util.io"})
final class WinPowerService
implements PowerService {
    private final Kernel32 kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class);

    @Override
    @NotNull
    public PowerStatus status() {
        SYSTEM_POWER_STATUS status = new SYSTEM_POWER_STATUS();
        if (!this.kernel32.GetSystemPowerStatus(status)) {
            throw new IOException("GetSystemPowerStatus(): " + this.kernel32.GetLastError());
        }
        if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
            PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug("ACLineStatus=" + status.ACLineStatus);
        }
        return switch (status.ACLineStatus) {
            case 0 -> PowerStatus.BATTERY;
            case 1 -> PowerStatus.AC;
            default -> PowerStatus.UNKNOWN;
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/io/WinPowerService$Kernel32;", "Lcom/sun/jna/win32/StdCallLibrary;", "GetSystemPowerStatus", "", "result", "Lcom/intellij/util/io/WinPowerService$SYSTEM_POWER_STATUS;", "GetLastError", "", "intellij.platform.ide.util.io"})
    private static interface Kernel32
    extends StdCallLibrary {
        public boolean GetSystemPowerStatus(@NotNull SYSTEM_POWER_STATUS var1);

        public int GetLastError();
    }

    @Structure.FieldOrder(value={"ACLineStatus", "BatteryFlag", "BatteryLifePercent", "SystemStatusFlag", "BatteryLifeTime", "BatteryFullLifeTime"})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/util/io/WinPowerService$SYSTEM_POWER_STATUS;", "Lcom/sun/jna/Structure;", "<init>", "()V", "ACLineStatus", "", "BatteryFlag", "BatteryLifePercent", "SystemStatusFlag", "BatteryLifeTime", "", "BatteryFullLifeTime", "intellij.platform.ide.util.io"})
    public static final class SYSTEM_POWER_STATUS
    extends Structure {
        @JvmField
        public byte ACLineStatus;
        @JvmField
        public byte BatteryFlag;
        @JvmField
        public byte BatteryLifePercent;
        @JvmField
        public byte SystemStatusFlag;
        @JvmField
        public int BatteryLifeTime;
        @JvmField
        public int BatteryFullLifeTime;
    }
}

