/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler;", "", "<init>", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "checkServerState", "", "getSettingsFromServer", "syncSettings", "Lcom/intellij/settingsSync/SettingsSyncState;", "pushSettingsToServer", "addListener", "listener", "State", "Listener", "intellij.settingsSync"})
public final class SettingsSyncEnabler {
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;

    public SettingsSyncEnabler() {
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
    }

    public final void checkServerState() {
        ((Listener)this.eventDispatcher.getMulticaster()).serverStateCheckStarted();
        SettingsSyncRemoteCommunicator communicator = SettingsSyncMain.Companion.getInstance().getRemoteCommunicator$intellij_settingsSync();
        String string = SettingsSyncBundle.INSTANCE.message("enable.sync.check.server.data.progress", new Object[0]);
        new Task.Modal(communicator, this, string){
            private UpdateResult updateResult;
            final /* synthetic */ SettingsSyncRemoteCommunicator $communicator;
            final /* synthetic */ SettingsSyncEnabler this$0;
            {
                this.$communicator = $communicator;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.updateResult = this.$communicator.receiveUpdates();
            }

            public void onCancel() {
                this.updateResult = State.INSTANCE.getCANCELLED();
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                UpdateResult updateResult = this.updateResult;
                if (updateResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"updateResult");
                    updateResult = null;
                }
                listener.serverStateCheckFinished(updateResult);
            }
        }.queue();
    }

    public final void getSettingsFromServer(@Nullable SettingsSyncState syncSettings) {
        ((Listener)this.eventDispatcher.getMulticaster()).updateFromServerStarted();
        SettingsSyncMain.SettingsSyncControls settingsSyncControls = SettingsSyncMain.Companion.getInstance().getControls();
        String string = SettingsSyncBundle.INSTANCE.message("enable.sync.get.from.server.progress", new Object[0]);
        new Task.Modal(settingsSyncControls, syncSettings, this, string){
            private UpdateResult updateResult;
            final /* synthetic */ SettingsSyncMain.SettingsSyncControls $settingsSyncControls;
            final /* synthetic */ SettingsSyncState $syncSettings;
            final /* synthetic */ SettingsSyncEnabler this$0;
            {
                this.$settingsSyncControls = $settingsSyncControls;
                this.$syncSettings = $syncSettings;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                UpdateResult result;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.updateResult = result = this.$settingsSyncControls.getRemoteCommunicator().receiveUpdates();
                if (result instanceof UpdateResult.Success) {
                    SyncSettingsEvent.CloudChange cloudEvent = new SyncSettingsEvent.CloudChange(((UpdateResult.Success)result).getSettingsSnapshot(), ((UpdateResult.Success)result).getServerVersionId(), this.$syncSettings);
                    this.$settingsSyncControls.getBridge().initialize$intellij_settingsSync(new SettingsSyncBridge.InitMode.TakeFromServer(cloudEvent));
                }
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                UpdateResult updateResult = this.updateResult;
                if (updateResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"updateResult");
                    updateResult = null;
                }
                listener.updateFromServerFinished(updateResult);
            }
        }.queue();
    }

    public static /* synthetic */ void getSettingsFromServer$default(SettingsSyncEnabler settingsSyncEnabler, SettingsSyncState settingsSyncState, int n, Object object) {
        if ((n & 1) != 0) {
            settingsSyncState = null;
        }
        settingsSyncEnabler.getSettingsFromServer(settingsSyncState);
    }

    public final void pushSettingsToServer() {
        SettingsSyncMain.SettingsSyncControls settingsSyncControls = SettingsSyncMain.Companion.getInstance().getControls();
        settingsSyncControls.getBridge().initialize$intellij_settingsSync(SettingsSyncBridge.InitMode.PushToServer.INSTANCE);
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(SettingsSyncEnabler $this) {
        return $this.eventDispatcher;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "Ljava/util/EventListener;", "serverStateCheckStarted", "", "serverStateCheckFinished", "state", "Lcom/intellij/settingsSync/UpdateResult;", "updateFromServerStarted", "updateFromServerFinished", "result", "serverRequestStarted", "serverRequestFinished", "intellij.settingsSync"})
    public static interface Listener
    extends EventListener {
        default public void serverStateCheckStarted() {
            this.serverRequestStarted();
        }

        default public void serverStateCheckFinished(@NotNull UpdateResult state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.serverRequestFinished();
        }

        default public void updateFromServerStarted() {
            this.serverRequestStarted();
        }

        default public void updateFromServerFinished(@NotNull UpdateResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.serverRequestFinished();
        }

        default public void serverRequestStarted() {
        }

        default public void serverRequestFinished() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncEnabler$State;", "", "<init>", "()V", "CANCELLED", "Lcom/intellij/settingsSync/UpdateResult$Error;", "getCANCELLED", "()Lcom/intellij/settingsSync/UpdateResult$Error;", "intellij.settingsSync"})
    public static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        @NotNull
        private static final UpdateResult.Error CANCELLED = new UpdateResult.Error("Cancelled");

        private State() {
        }

        @NotNull
        public final UpdateResult.Error getCANCELLED() {
            return CANCELLED;
        }
    }
}

