/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextBlockModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rdclient.daemon.util.StringUtilKt;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\n*\u00020\u000bJ\n\u0010\f\u001a\u00020\u0005*\u00020\u000bJ\n\u0010\f\u001a\u00020\u0005*\u00020\rJ\u000f\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\n*\u00020\u0005J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u000bH\u0007J\n\u0010\u000f\u001a\u00020\u0005*\u00020\u000bJ\u0014\u0010\u0010\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/ui/RichTextHtmlUtils;", "", "<init>", "()V", "TOOLTIP_SEPARATOR", "", "SEPARATOR_COLOR", "SEPARATOR_TAG", "HR_SEPARATOR_TAG", "escapeToIdeaTooltip", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/rd/ide/model/RichAttributedTextModel;", "escapeAndHighlight", "Lcom/jetbrains/rd/ide/model/RichAttributedTextBlockModel;", "highlightAttributedParts", "removeAttributes", "highlight", "model", "Lcom/jetbrains/rd/ide/model/RichAttributedStringModel;", "applyFontStyle", "toTag", "Lcom/jetbrains/rd/ide/model/FontStyle;", "fixLeadingSpaces", "leadingSpacesRegex", "Lkotlin/text/Regex;", "intellij.rd.client"})
public final class RichTextHtmlUtils {
    @NotNull
    public static final RichTextHtmlUtils INSTANCE = new RichTextHtmlUtils();
    @NotNull
    public static final String TOOLTIP_SEPARATOR = "_HORIZONTAL_LINE_TOOLTIP_SEPARATOR_";
    @NotNull
    private static final String SEPARATOR_COLOR = "SEPARATOR_COLOR";
    @NotNull
    private static final String SEPARATOR_TAG = "<div style=\"padding-bottom:5px;margin-bottom:5px;border-bottom: thin solid #SEPARATOR_COLOR;\">";
    @NotNull
    private static final String HR_SEPARATOR_TAG = "<hr size=1 noshade>";
    @NotNull
    private static final Regex leadingSpacesRegex = new Regex("<br> +");

    private RichTextHtmlUtils() {
    }

    @NotNull
    public final String escapeToIdeaTooltip(@NotNull RichAttributedTextModel $this$escapeToIdeaTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeToIdeaTooltip, (String)"<this>");
        return StringUtilKt.wrapInHtml(this.escapeAndHighlight($this$escapeToIdeaTooltip));
    }

    @NotNull
    public final String escapeAndHighlight(@NotNull RichAttributedTextModel $this$escapeAndHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeAndHighlight, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$escapeAndHighlight.getParts(), (CharSequence)"", null, null, (int)0, null, RichTextHtmlUtils::escapeAndHighlight$lambda$0, (int)30, null);
    }

    @NotNull
    public final String escapeAndHighlight(@NotNull RichAttributedTextBlockModel $this$escapeAndHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeAndHighlight, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$escapeAndHighlight.getLines(), (CharSequence)"<br>", null, null, (int)0, null, RichTextHtmlUtils::escapeAndHighlight$lambda$1, (int)30, null);
    }

    @NotNull
    public final String escapeToIdeaTooltip(@NotNull String $this$escapeToIdeaTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeToIdeaTooltip, (String)"<this>");
        String string = StringUtilKt.escapeString($this$escapeToIdeaTooltip);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeString(...)");
        return StringUtilKt.wrapInHtml(StringsKt.replace$default((String)this.fixLeadingSpaces(StringUtilKt.escapeNewLines(string)), (String)TOOLTIP_SEPARATOR, (String)HR_SEPARATOR_TAG, (boolean)false, (int)4, null));
    }

    @Nls
    @NotNull
    public final String highlightAttributedParts(@NotNull RichAttributedTextModel $this$highlightAttributedParts) {
        Intrinsics.checkNotNullParameter((Object)$this$highlightAttributedParts, (String)"<this>");
        StringBuilder buffer = new StringBuilder();
        for (RichAttributedStringModel element : $this$highlightAttributedParts.getParts()) {
            String string;
            if (StringsKt.contains$default((CharSequence)element.getText(), (CharSequence)TOOLTIP_SEPARATOR, (boolean)false, (int)2, null)) {
                String string2 = ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHex(...)");
                buffer.insert(0, StringsKt.replace$default((String)SEPARATOR_TAG, (String)SEPARATOR_COLOR, (String)string2, (boolean)false, (int)4, null));
                string = StringsKt.replace$default((String)element.getText(), (String)TOOLTIP_SEPARATOR, (String)"</div>", (boolean)false, (int)4, null);
            } else {
                string = element.getText();
            }
            String escapedText = string;
            buffer.append(this.applyFontStyle(this.highlight(escapedText, element), element));
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String removeAttributes(@NotNull RichAttributedTextModel $this$removeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAttributes, (String)"<this>");
        StringBuilder buffer = new StringBuilder();
        for (RichAttributedStringModel element : $this$removeAttributes.getParts()) {
            String string;
            if (StringsKt.contains$default((CharSequence)element.getText(), (CharSequence)TOOLTIP_SEPARATOR, (boolean)false, (int)2, null)) {
                String string2 = ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHex(...)");
                buffer.insert(0, StringsKt.replace$default((String)SEPARATOR_TAG, (String)SEPARATOR_COLOR, (String)string2, (boolean)false, (int)4, null));
                string = StringsKt.replace$default((String)element.getText(), (String)TOOLTIP_SEPARATOR, (String)"</div>", (boolean)false, (int)4, null);
            } else {
                string = element.getText();
            }
            String escapedText = string;
            buffer.append(escapedText);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String highlight(String $this$highlight, RichAttributedStringModel model) {
        TextAttributesKeyModel textAttributesKeyModel = model.getTextAttributesKey();
        if (textAttributesKeyModel == null) {
            return $this$highlight;
        }
        TextAttributesKeyModel textAttributesKeyModel2 = textAttributesKeyModel;
        TextAttributes textAttributes = FrontendHighlighterAttributeCustomizer.Companion.getTextAttributes(textAttributesKeyModel2);
        if (textAttributes == null && (textAttributes = TextAttributesRegistrationHost.getTextAttributes$default((TextAttributesRegistrationHost)TextAttributesRegistrationHost.Companion.getInstance(), (TextAttributesKeyModel)textAttributesKeyModel2, null, (int)2, null)) == null) {
            return $this$highlight;
        }
        TextAttributes attributes = textAttributes;
        Color color = attributes.getForegroundColor();
        if (color == null) {
            return $this$highlight;
        }
        Color foregroundColor = color;
        return "<span style=\"color:#" + ColorUtil.toHex((Color)foregroundColor) + "\">" + $this$highlight + "</span>";
    }

    private final String applyFontStyle(String $this$applyFontStyle, RichAttributedStringModel model) {
        String string = this.toTag(model.getFontStyle());
        if (string == null) {
            return $this$applyFontStyle;
        }
        String tag = string;
        return "<" + tag + ">" + $this$applyFontStyle + "</" + tag + ">";
    }

    private final String toTag(FontStyle $this$toTag) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toTag.ordinal()]) {
            case 1 -> null;
            case 2 -> "b";
            case 3 -> "i";
            case 4 -> "u";
            case 5 -> "s";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String fixLeadingSpaces(String $this$fixLeadingSpaces) {
        CharSequence charSequence = $this$fixLeadingSpaces;
        Regex regex = leadingSpacesRegex;
        Function1 function1 = RichTextHtmlUtils::fixLeadingSpaces$lambda$2;
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence escapeAndHighlight$lambda$0(RichAttributedStringModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtilKt.escapeString(it.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeString(...)");
        return INSTANCE.applyFontStyle(INSTANCE.highlight(StringsKt.replace$default((String)INSTANCE.fixLeadingSpaces(StringUtilKt.escapeNewLines(string)), (String)TOOLTIP_SEPARATOR, (String)HR_SEPARATOR_TAG, (boolean)false, (int)4, null), it), it);
    }

    private static final CharSequence escapeAndHighlight$lambda$1(RichAttributedTextModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.escapeAndHighlight(it);
    }

    private static final CharSequence fixLeadingSpaces$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.replace$default((String)it.getValue(), (char)' ', (char)'\u00a0', (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FontStyle.values().length];
            try {
                nArray[FontStyle.Regular.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Bold.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Italic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Underline.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Strikeout.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

