/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/collaboration/ui/OrientableScrollablePanel;", "Ljavax/swing/JPanel;", "Ljavax/swing/Scrollable;", "orientation", "", "layout", "Ljava/awt/LayoutManager;", "<init>", "(ILjava/awt/LayoutManager;)V", "verticalUnit", "horizontalUnit", "addNotify", "", "getScrollableUnitIncrement", "visibleRect", "Ljava/awt/Rectangle;", "direction", "getScrollableBlockIncrement", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "getScrollableTracksViewportWidth", "", "getScrollableTracksViewportHeight", "intellij.platform.collaborationTools"})
final class OrientableScrollablePanel
extends JPanel
implements Scrollable {
    private final int orientation;
    private int verticalUnit;
    private int horizontalUnit;

    public OrientableScrollablePanel(int orientation, @Nullable LayoutManager layout) {
        super(layout);
        this.orientation = orientation;
        this.verticalUnit = 1;
        this.horizontalUnit = 1;
        if (!(this.orientation == 1 || this.orientation == 0)) {
            boolean bl = false;
            String string = "SwingConstants.VERTICAL or SwingConstants.HORIZONTAL is expected for orientation, got " + this.orientation;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.verticalUnit = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.horizontalUnit = fontMetrics.charWidth('W');
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return orientation == 0 ? this.horizontalUnit : this.verticalUnit;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return orientation == 0 ? visibleRect.width : visibleRect.height;
    }

    @Override
    @Nullable
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.orientation == 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.orientation == 0;
    }
}

