/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.httpclient.response;

import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler;", "T", "Ljava/net/http/HttpResponse$BodyHandler;", "handler", "<init>", "(Ljava/net/http/HttpResponse$BodyHandler;)V", "cancelled", "", "currentSubscription", "Ljava/util/concurrent/Flow$Subscription;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "apply", "Ljava/net/http/HttpResponse$BodySubscriber;", "responseInfo", "Ljava/net/http/HttpResponse$ResponseInfo;", "cancel", "", "SubscriberWrapper", "intellij.platform.collaborationTools"})
public final class CancellableWrappingBodyHandler<T>
implements HttpResponse.BodyHandler<T> {
    @NotNull
    private final HttpResponse.BodyHandler<T> handler;
    private volatile boolean cancelled;
    @Nullable
    private volatile Flow.Subscription currentSubscription;
    @NotNull
    private final ReentrantLock lock;

    public CancellableWrappingBodyHandler(@NotNull HttpResponse.BodyHandler<T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.handler = handler;
        this.lock = new ReentrantLock();
    }

    @Override
    @NotNull
    public HttpResponse.BodySubscriber<T> apply(@NotNull HttpResponse.ResponseInfo responseInfo) {
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
        HttpResponse.BodySubscriber<T> bodySubscriber = this.handler.apply(responseInfo);
        Intrinsics.checkNotNullExpressionValue(bodySubscriber, (String)"apply(...)");
        return new SubscriberWrapper<T>(bodySubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            this.cancelled = true;
            Flow.Subscription subscription = this.currentSubscription;
            if (subscription != null) {
                subscription.cancel();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00018\u0001 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00018\u0001\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\rJ\t\u0010\u000e\u001a\u00020\u0007H\u0096\u0001J\u001e\u0010\u000f\u001a\u00020\u00072\u000e\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010\u0012J:\u0010\u0013\u001a\u00020\u00072*\u0010\u0010\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00160\u0014H\u0096\u0001\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler$SubscriberWrapper;", "O", "Ljava/net/http/HttpResponse$BodySubscriber;", "subscriber", "<init>", "(Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler;Ljava/net/http/HttpResponse$BodySubscriber;)V", "onSubscribe", "", "subscription", "Ljava/util/concurrent/Flow$Subscription;", "getBody", "Ljava/util/concurrent/CompletionStage;", "kotlin.jvm.PlatformType", "()Ljava/util/concurrent/CompletionStage;", "onComplete", "onError", "p0", "", "(Ljava/lang/Throwable;)V", "onNext", "", "Ljava/nio/ByteBuffer;", "", "(Ljava/util/List;)V", "intellij.platform.collaborationTools"})
    private final class SubscriberWrapper<O>
    implements HttpResponse.BodySubscriber<O> {
        @NotNull
        private final HttpResponse.BodySubscriber<O> subscriber;

        public SubscriberWrapper(HttpResponse.BodySubscriber<O> subscriber2) {
            Intrinsics.checkNotNullParameter(subscriber2, (String)"subscriber");
            this.subscriber = subscriber2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribe(@NotNull Flow.Subscription subscription) {
            Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
            this.subscriber.onSubscribe(subscription);
            Lock lock = CancellableWrappingBodyHandler.this.lock;
            CancellableWrappingBodyHandler cancellableWrappingBodyHandler = CancellableWrappingBodyHandler.this;
            lock.lock();
            try {
                boolean bl = false;
                if (cancellableWrappingBodyHandler.cancelled) {
                    subscription.cancel();
                }
                cancellableWrappingBodyHandler.currentSubscription = subscription;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public CompletionStage<O> getBody() {
            return this.subscriber.getBody();
        }

        @Override
        public void onNext(List<ByteBuffer> p0) {
            this.subscriber.onNext(p0);
        }

        @Override
        public void onError(Throwable p0) {
            this.subscriber.onError(p0);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

