/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity.time;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.quantity.time.TemporalQuantity;
import tech.units.indriya.quantity.time.TimeUnitQuantity;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public final class TimeQuantities {
    public static final Unit<Time> MICROSECOND = new TransformedUnit<Time>("\u03bcs", Units.SECOND, Units.SECOND, (UnitConverter)MultiplyConverter.ofPrefix((Prefix)MetricPrefix.MICRO));
    public static final TransformedUnit<Time> MILLISECOND = new TransformedUnit<Time>("ms", Units.SECOND, Units.SECOND, (UnitConverter)MultiplyConverter.ofPrefix((Prefix)MetricPrefix.MILLI));
    public static final TransformedUnit<Time> NANOSECOND = new TransformedUnit<Time>("ns", Units.SECOND, Units.SECOND, (UnitConverter)MultiplyConverter.ofPrefix((Prefix)MetricPrefix.NANO));

    private TimeQuantities() {
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Temporal temporalB) {
        long days = ChronoUnit.DAYS.between(temporalA, temporalB);
        return Quantities.getQuantity(days, Units.DAY);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, LocalTime localTimeB) {
        long hours = ChronoUnit.HOURS.between(localTimeA, localTimeB);
        return Quantities.getQuantity(hours, Units.HOUR);
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Supplier<TemporalAdjuster> supplier) {
        Temporal temporalB = temporalA.with(supplier.get());
        return TimeQuantities.getQuantity(temporalA, temporalB);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, Supplier<TemporalAdjuster> supplier) {
        LocalTime localTimeB = localTimeA.with(supplier.get());
        return TimeQuantities.getQuantity(localTimeA, localTimeB);
    }

    public static TimeUnitQuantity getQuantity(Long number, TimeUnit timeUnit) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TemporalQuantity getQuantity(Long number, TemporalUnit temporalUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number), Objects.requireNonNull(temporalUnit));
    }

    public static TimeUnitQuantity toTimeUnitSeconds(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().longValue());
    }

    public static TemporalQuantity toTemporalSeconds(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return TemporalQuantity.of((Quantity<Time>)seconds);
    }
}

