/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.Command;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BaseResponseHandler;
import org.jsmpp.session.OutboundServerResponseHandler;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPOutboundServerSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPOutboundServerSessionOutbound
implements SMPPOutboundServerSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPOutboundServerSessionOutbound.class);
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPOutboundServerSessionOutbound() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.OUTBOUND;
    }

    @Override
    public void processOutbind(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processBindResp(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                BindResp resp = pduDecomposer.bindResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                String message = "Failed decomposing submit_sm_resp";
                logger.error(message, (Throwable)e);
                responseHandler.sendGenerickNack(e.getErrorCode(), pduHeader.getSequenceNumber());
                pendingResp.doneWithInvalidResponse(new InvalidResponseException(message, e));
            }
        } else {
            logger.error("No request with sequence number {} found", (Object)pduHeader.getSequenceNumber());
            responseHandler.sendGenerickNack(99, pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processDeliverSm(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected deliver_sm"));
        }
    }

    @Override
    public void processEnquireLink(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected enquire_link"));
        }
    }

    @Override
    public void processEnquireLinkResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected enquire_link_resp"));
        }
    }

    @Override
    public void processGenericNack(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected generic_nack"));
        }
    }

    @Override
    public void processUnbind(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected unbind"));
        }
    }

    @Override
    public void processUnbindResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected unbind_resp"));
        }
    }

    @Override
    public void processUnknownCid(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unknown command_id"));
        }
    }

    @Override
    public void processDataSm(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected data_sm"));
        }
    }

    @Override
    public void processDataSmResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected data_sm_resp"));
        }
    }

    public void processAlertNotification(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(1);
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new InvalidResponseException("Receive unexpected alert_notification"));
        }
    }
}

