/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.gui.jobs.ITaskProgress;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.UiUtils;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3238438119672015733L;
    private static final Icon ICON_CANCEL = UiUtils.openSvgIcon("ui/close");
    private final JProgressBar progressBar;
    private final JLabel progressLabel;
    private final JButton cancelButton;
    private final boolean showCancelButton;

    public ProgressPanel(MainWindow mainWindow, boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
        this.progressLabel.setLabelFor(this.progressBar);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 0));
        this.setVisible(false);
        this.add(this.progressLabel);
        this.add(this.progressBar);
        this.cancelButton = new JButton(ICON_CANCEL);
        this.cancelButton.setPreferredSize(new Dimension(ICON_CANCEL.getIconWidth(), ICON_CANCEL.getIconHeight()));
        this.cancelButton.setToolTipText("Cancel background jobs");
        this.cancelButton.setBorderPainted(false);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setContentAreaFilled(false);
        this.cancelButton.addActionListener(e -> mainWindow.cancelBackgroundJobs());
        this.cancelButton.setVisible(showCancelButton);
        this.add(this.cancelButton);
    }

    public void reset() {
        this.cancelButton.setVisible(this.showCancelButton);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("");
        this.progressBar.setStringPainted(true);
    }

    public void setProgress(ITaskProgress taskProgress) {
        int progress = taskProgress.progress();
        int total = taskProgress.total();
        if (progress == 0 || total == 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.setProgress(UiUtils.calcProgress(progress, total));
        }
    }

    private void setProgress(int progress) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(progress);
        this.progressBar.setString(progress + "%");
        this.progressBar.setStringPainted(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "progress": {
                this.setProgress((Integer)evt.getNewValue());
                break;
            }
            case "label": {
                this.setLabel((String)evt.getNewValue());
                break;
            }
            case "visible": {
                this.setVisible((Boolean)evt.getNewValue());
                break;
            }
            case "indeterminate": {
                this.setIndeterminate((Boolean)evt.getNewValue());
                break;
            }
            case "cancel-visible": {
                this.cancelButton.setVisible((Boolean)evt.getNewValue());
            }
        }
    }

    public void setLabel(String label) {
        this.progressLabel.setText(label);
    }

    public void setIndeterminate(boolean newValue) {
        this.progressBar.setIndeterminate(newValue);
    }

    public void changeLabel(SwingWorker<?, ?> task, String label) {
        task.firePropertyChange("label", null, label);
    }

    public void changeIndeterminate(SwingWorker<?, ?> task, boolean indeterminate) {
        task.firePropertyChange("indeterminate", null, indeterminate);
    }

    public void changeVisibility(SwingWorker<?, ?> task, boolean visible) {
        task.firePropertyChange("visible", null, visible);
    }

    public void changeCancelBtnVisible(SwingWorker<?, ?> task, boolean visible) {
        task.firePropertyChange("cancel-visible", null, visible);
    }
}

