/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common;

public class RaungAccessFlags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MODULE = 32768;
    public static final int CONSTRUCTOR = 65536;
    public static final int DECLARED_SYNCHRONIZED = 131072;

    public static boolean hasFlag(int flags, int flagValue) {
        return (flags & flagValue) != 0;
    }

    public static String format(int flags, Scope scope) {
        if (flags == 0) {
            return "";
        }
        StringBuilder code = new StringBuilder();
        if (RaungAccessFlags.hasFlag(flags, 1)) {
            code.append("public ");
        }
        if (RaungAccessFlags.hasFlag(flags, 2)) {
            code.append("private ");
        }
        if (RaungAccessFlags.hasFlag(flags, 4)) {
            code.append("protected ");
        }
        if (RaungAccessFlags.hasFlag(flags, 8)) {
            code.append("static ");
        }
        if (RaungAccessFlags.hasFlag(flags, 16)) {
            code.append("final ");
        }
        if (RaungAccessFlags.hasFlag(flags, 1024)) {
            code.append("abstract ");
        }
        if (RaungAccessFlags.hasFlag(flags, 256)) {
            code.append("native ");
        }
        switch (scope) {
            case METHOD: {
                if (RaungAccessFlags.hasFlag(flags, 32)) {
                    code.append("synchronized ");
                }
                if (RaungAccessFlags.hasFlag(flags, 64)) {
                    code.append("bridge ");
                }
                if (!RaungAccessFlags.hasFlag(flags, 128)) break;
                code.append("varargs ");
                break;
            }
            case FIELD: {
                if (RaungAccessFlags.hasFlag(flags, 64)) {
                    code.append("volatile ");
                }
                if (!RaungAccessFlags.hasFlag(flags, 128)) break;
                code.append("transient ");
                break;
            }
            case CLASS: {
                if (RaungAccessFlags.hasFlag(flags, 32768)) {
                    code.append("module ");
                }
                if (RaungAccessFlags.hasFlag(flags, 2048)) {
                    code.append("strict ");
                }
                if (RaungAccessFlags.hasFlag(flags, 32)) {
                    code.append("super ");
                }
                if (RaungAccessFlags.hasFlag(flags, 16384)) {
                    code.append("enum ");
                }
                if (RaungAccessFlags.hasFlag(flags, 8192)) {
                    code.append("annotation ");
                }
                if (!RaungAccessFlags.hasFlag(flags, 512)) break;
                code.append("interface ");
            }
        }
        if (RaungAccessFlags.hasFlag(flags, 4096)) {
            code.append("synthetic ");
        }
        return code.toString();
    }

    public static enum Scope {
        CLASS(1),
        FIELD(2),
        METHOD(4),
        PARAM(8),
        ANY(15);

        private final int flag;

        private Scope(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

