/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.DataHelper;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.tasks.ThreadDump;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class RouterWatchdog
implements Runnable {
    private final Log _log;
    private final RouterContext _context;
    private int _consecutiveErrors;
    private volatile boolean _isRunning;
    private long _lastDump;
    private static final long MAX_JOB_RUN_LAG = 60000L;
    private static final long MIN_DUMP_INTERVAL = 21600000L;

    public RouterWatchdog(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(RouterWatchdog.class);
        this._isRunning = true;
    }

    public void shutdown() {
        this._isRunning = false;
    }

    public boolean verifyJobQueueLiveliness() {
        long when = this._context.jobQueue().getLastJobBegin();
        if (when < 0L) {
            return true;
        }
        long howLongAgo = this._context.clock().now() - when;
        if (howLongAgo > 60000L) {
            Job cur = this._context.jobQueue().getLastJob();
            if (cur != null) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Last job was queued up " + DataHelper.formatDuration(howLongAgo) + " ago: " + cur);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean verifyClientLiveliness() {
        return this._context.clientManager().verifyClientLiveliness();
    }

    private boolean shutdownOnHang() {
        if (!this._context.getBooleanProperty("watchdog.haltOnHang")) {
            return false;
        }
        return this._consecutiveErrors >= 20 && SystemVersion.hasWrapper();
    }

    private void dumpStatus() {
        if (this._log.shouldLog(40)) {
            RateStat rs = this._context.statManager().getRate("transport.sendProcessingTime");
            Rate r = null;
            if (rs != null) {
                r = rs.getRate(60000L);
            }
            double processTime = r != null ? r.getAverageValue() : 0.0;
            rs = this._context.statManager().getRate("bw.sendBps");
            r = null;
            if (rs != null) {
                r = rs.getRate(60000L);
            }
            double bps = r != null ? r.getAverageValue() : 0.0;
            long max = Runtime.getRuntime().maxMemory();
            long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this._log.error("Watchdog status\nComm system: " + (Object)((Object)this._context.commSystem().getStatus()) + "\nPeers: " + this._context.commSystem().countActivePeers() + "\nReady and waiting jobs: " + this._context.jobQueue().getReadyCount() + "\nLag: " + DataHelper.formatDuration(this._context.jobQueue().getMaxLag()) + "\nPart. tunnels: " + this._context.tunnelManager().getParticipatingCount() + "\nSend processing time: " + DataHelper.formatDuration((long)processTime) + "\nSend rate: " + DataHelper.formatSize((long)bps) + "Bps\nMemory: " + DataHelper.formatSize(used) + "B / " + DataHelper.formatSize(max) + 'B');
            if (this._consecutiveErrors == 1) {
                this._log.log(50, "Router appears hung, or there is severe network congestion.  Watchdog starts barking!");
                this._context.router().eventLog().addEvent("watchdog");
                long now = this._context.clock().now();
                if (now - this._lastDump > 21600000L) {
                    this._lastDump = now;
                    ThreadDump.dump(this._context, 10);
                }
            }
        }
    }

    @Override
    public void run() {
        while (this._isRunning) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitorRouter();
        }
    }

    public void monitorRouter() {
        boolean ok = this.verifyJobQueueLiveliness();
        long netErrors = 0L;
        if (this._context.commSystem().getStatus() == CommSystemFacade.Status.DISCONNECTED) {
            netErrors = 10L;
        } else {
            Rate r;
            RateStat rs = this._context.statManager().getRate("udp.sendException");
            if (rs != null && (r = rs.getRate(60000L)) != null) {
                netErrors = r.getLastEventCount();
            }
        }
        boolean bl = ok = ok && (this.verifyClientLiveliness() || netErrors >= 5L);
        if (ok) {
            this._consecutiveErrors = 0;
        } else {
            ++this._consecutiveErrors;
            this.dumpStatus();
            if (this.shutdownOnHang()) {
                this._log.log(50, "Router hung!  Restart forced by watchdog!");
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(4);
            }
        }
    }
}

