/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ruleconfig.DialogEditRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.ExtensionRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigTableModel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;

public class OptionsRuleConfigPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(OptionsRuleConfigPanel.class);
    private ExtensionRuleConfig extension;
    private RuleConfigOptionsPanel ruleConfigOptionsPanel;
    private JButton resetButton;
    private RuleConfigTableModel ruleConfigModel;

    public OptionsRuleConfigPanel(ExtensionRuleConfig extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("ruleconfig.options.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 21;
        gbc.fill = 1;
        this.ruleConfigOptionsPanel = new RuleConfigOptionsPanel(this.getRuleConfigModel());
        gbc.weighty = 1.0;
        this.add((Component)this.ruleConfigOptionsPanel, LayoutHelper.getGBC(0, 0, 5, 1.0, 1.0, 1, 21, null));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 1, 1, 0.5, 0.0));
        this.add((Component)this.getResetButton(), LayoutHelper.getGBC(3, 1, 1, 0.0, 0.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(4, 1, 1, 0.5, 0.0));
    }

    @Override
    public void initParam(Object obj) {
        this.getRuleConfigModel().setRuleConfigs(this.extension.getAllRuleConfigs());
        this.ruleConfigOptionsPanel.packAll();
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton(Constant.messages.getString("ruleconfig.options.button.reset"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (RuleConfig rc : OptionsRuleConfigPanel.this.getRuleConfigModel().getElements()) {
                        rc.reset();
                    }
                    OptionsRuleConfigPanel.this.getRuleConfigModel().fireTableDataChanged();
                }
            });
        }
        return this.resetButton;
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        for (RuleConfig rc : this.getRuleConfigModel().getElements()) {
            if (!rc.isChanged()) continue;
            logger.debug("Setting rule config " + rc.getKey() + " to " + rc.getValue());
            this.extension.setRuleConfigValue(rc.getKey(), rc.getValue());
        }
    }

    private RuleConfigTableModel getRuleConfigModel() {
        if (this.ruleConfigModel == null) {
            this.ruleConfigModel = new RuleConfigTableModel();
        }
        return this.ruleConfigModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ruleconfig";
    }

    private static class RuleConfigOptionsPanel
    extends MultipleOptionsTablePanel {
        private static final long serialVersionUID = -115340627058929308L;
        private DialogEditRuleConfig modifyDialog = null;
        private RuleConfigTableModel model;

        public RuleConfigOptionsPanel(final RuleConfigTableModel model) {
            super(model);
            this.model = model;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
            this.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int row;
                    if (SwingUtilities.isLeftMouseButton(e) && (row = this.getTable().getSelectedRow()) >= 0) {
                        this.showModifyDialogue(model.getElements().get(this.getTable().convertRowIndexToModel(row)));
                    }
                }
            });
        }

        protected void packAll() {
            this.getTable().packAll();
        }

        public void showModifyDialogue(RuleConfig rc) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogEditRuleConfig((Window)View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.init(rc, this.model);
            this.modifyDialog.setVisible(true);
        }
    }
}

