/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeMatcherEditor<D extends Comparable, E>
extends AbstractMatcherEditor<E> {
    private final Filterator<D, E> filterator;
    private D currentRangeStart;
    private D currentRangeEnd;

    public RangeMatcherEditor() {
        this(null);
    }

    public RangeMatcherEditor(Filterator<D, E> filterator) {
        this.filterator = filterator;
    }

    public Filterator<D, E> getFilterator() {
        return this.filterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(D newStart, D newEnd) {
        if (newStart != null && newEnd != null && newStart.compareTo(newEnd) > 0) {
            D temp = newEnd;
            newEnd = newStart;
            newStart = temp;
        }
        try {
            if (newStart == null && newEnd == null) {
                if (this.currentRangeStart != null || this.currentRangeEnd != null) {
                    this.fireMatchAll();
                }
                return;
            }
            boolean isRelaxed = false;
            boolean isConstrained = false;
            int newStartVsOldStart = RangeMatcherEditor.compare(newStart, this.currentRangeStart, true);
            isRelaxed |= newStartVsOldStart < 0;
            isConstrained |= newStartVsOldStart > 0;
            int newEndVsOldEnd = RangeMatcherEditor.compare(newEnd, this.currentRangeEnd, false);
            Matcher<E> matcher = Matchers.rangeMatcher(newStart, newEnd, this.filterator);
            if ((isRelaxed |= newEndVsOldEnd > 0) && (isConstrained |= newEndVsOldEnd < 0)) {
                this.fireChanged(matcher);
            } else if (isRelaxed) {
                this.fireRelaxed(matcher);
            } else if (isConstrained) {
                this.fireConstrained(matcher);
            }
        }
        finally {
            this.currentRangeStart = newStart;
            this.currentRangeEnd = newEnd;
        }
    }

    private static int compare(Comparable a, Comparable b, boolean nullsBeforeAll) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return nullsBeforeAll ? -1 : 1;
        }
        if (b == null) {
            return nullsBeforeAll ? 1 : -1;
        }
        return a.compareTo(b);
    }
}

