/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.impl.matchers.BeanPropertyMatcher;
import ca.odell.glazedlists.impl.matchers.FalseMatcher;
import ca.odell.glazedlists.impl.matchers.NotMatcher;
import ca.odell.glazedlists.impl.matchers.RangeMatcher;
import ca.odell.glazedlists.impl.matchers.TrueMatcher;
import ca.odell.glazedlists.impl.matchers.WeakReferenceMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Matchers {
    private Matchers() {
        throw new UnsupportedOperationException();
    }

    public static <E> MatcherEditor<E> weakReferenceProxy(MatcherEditor<E> matcherEditor) {
        return new WeakReferenceMatcherEditor<E>(matcherEditor);
    }

    public static <E> Matcher<E> trueMatcher() {
        return TrueMatcher.getInstance();
    }

    public static <E> Matcher<E> falseMatcher() {
        return FalseMatcher.getInstance();
    }

    public static <E> Matcher<E> invert(Matcher<E> original) {
        return new NotMatcher<E>(original);
    }

    public static <E> Matcher<E> beanPropertyMatcher(Class<E> beanClass, String propertyName, Object expectedValue) {
        return new BeanPropertyMatcher<E>(beanClass, propertyName, expectedValue);
    }

    public static <D extends Comparable, E> Matcher<E> rangeMatcher(D start, D end) {
        return new RangeMatcher(start, end);
    }

    public static <D extends Comparable, E> Matcher<E> rangeMatcher(D start, D end, Filterator<D, E> filterator) {
        return new RangeMatcher<D, E>(start, end, filterator);
    }

    public static <E> boolean filter(Collection<E> collection, Matcher<? super E> matcher) {
        boolean changed = false;
        Iterator<E> i = collection.iterator();
        while (i.hasNext()) {
            E element = i.next();
            if (matcher.matches(element)) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }
}

