/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.ical4j.impl.prefs;

import au.com.trgtd.tr.calendar.ical4j.impl.prefs.Options;
import au.com.trgtd.tr.calendar.prefs.TimeZones;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizerOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class OptionsPanel
extends JPanel
implements CalendarSynchronizerOptions {
    private boolean changed;
    private static Vector<String> tzlist;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderField;
    private JComboBox timezoneCombo;
    private JLabel timezoneLabel;

    public OptionsPanel() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.folderLabel = new JLabel(OptionsPanel.getMsg("folderLabel"));
        this.folderField = new JTextField();
        this.folderField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent evt) {
                OptionsPanel.this.changed = true;
            }

            public void removeUpdate(DocumentEvent evt) {
                OptionsPanel.this.changed = true;
            }

            public void changedUpdate(DocumentEvent evt) {
                OptionsPanel.this.changed = true;
            }
        });
        this.folderButton = new JButton(OptionsPanel.getMsg("folderButton"));
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.browse();
            }
        });
        this.timezoneLabel = new JLabel(OptionsPanel.getMsg("timezoneLabel"));
        this.timezoneCombo = new JComboBox();
        this.timezoneCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.changed = true;
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "4[]2[grow]2[]4", "4[]4"));
        panel.add((Component)this.folderLabel, "align left");
        panel.add((Component)this.folderField, "align left, growx 100");
        panel.add((Component)this.folderButton, "align left, wrap");
        panel.add((Component)this.timezoneLabel, "align left");
        panel.add((Component)this.timezoneCombo, "align left, wrap");
        return panel;
    }

    public boolean changed() {
        return this.changed;
    }

    public void load() {
        this.initTimeZoneItems();
        this.timezoneCombo.setModel(new DefaultComboBoxModel<String>(tzlist));
        this.timezoneCombo.setMaximumRowCount(30);
        this.timezoneCombo.setSelectedItem(Options.getTimeZoneID());
        this.folderField.setText(Options.getICalendarPath());
        this.changed = false;
    }

    private void initTimeZoneItems() {
        tzlist = new Vector();
        tzlist.add("");
        for (String id : TimeZones.IDS) {
            tzlist.add(id);
        }
        Collections.sort(tzlist);
    }

    public void store() {
        if (this.isValidPath()) {
            Options.setICalendarPath(this.tidyPath(this.folderField.getText()));
        } else {
            Options.setICalendarPath("");
        }
        String tzid = (String)this.timezoneCombo.getSelectedItem();
        if (tzid != null) {
            Options.setTimeZoneID(tzid);
        }
        this.changed = false;
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean valid() {
        return this.isValidPath();
    }

    private boolean isValidPath() {
        String path = this.tidyPath(this.folderField.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    public void enable(boolean b) {
        this.folderLabel.setEnabled(b);
        this.folderButton.setEnabled(b);
        this.folderField.setEnabled(b);
        this.timezoneLabel.setEnabled(b);
        this.timezoneCombo.setEnabled(b);
    }

    private void browse() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderField.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.folderField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderField.setText("");
            }
        }
    }

    public static String getMsg(String key) {
        return NbBundle.getMessage(OptionsPanel.class, (String)key);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

